/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.mongo;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import eu.dnetlib.cql.CqlTranslator;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.PublisherStore;
import eu.dnetlib.oai.RecordChangeDetector;
import eu.dnetlib.oai.info.RecordInfo;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.oai.mongo.DNetOAIMongoCursor;
import eu.dnetlib.oai.mongo.MetadataExtractor;
import eu.dnetlib.oai.mongo.RecordInfoGenerator;
import eu.dnetlib.oai.parser.PublisherRecordParser;
import eu.dnetlib.oai.sets.MongoSetCollection;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class MongoPublisherStore
implements PublisherStore<DNetOAIMongoCursor> {
    private static final Log log = LogFactory.getLog(MongoPublisherStore.class);
    private String id;
    private String metadataFormat;
    private String interpretation;
    private String layout;
    private List<PublisherField> mongoFields;
    private MongoCollection<DBObject> collection;
    private MongoCollection<DBObject> discardedCollection;
    private CqlTranslator cqlTranslator;
    private RecordInfoGenerator recordInfoGenerator;
    private MetadataExtractor metadataExtractor;
    private RecordChangeDetector recordChangeDetector;
    private MongoSetCollection mongoSetCollection;
    private String idScheme;
    private String idNamespace;
    private boolean alwaysNewRecord;

    public MongoPublisherStore() {
    }

    public MongoPublisherStore(String id, String metadataFormat, String interpretation, String layout, MongoCollection<DBObject> collection, List<PublisherField> mongoFields, CqlTranslator cqlTranslator, RecordInfoGenerator recordInfoGenerator, String idScheme, String idNamespace, MetadataExtractor metadataExtractor, RecordChangeDetector recordChangeDetector, boolean alwaysNewRecord, MongoDatabase mongodb) {
        this.id = id;
        this.metadataFormat = metadataFormat;
        this.interpretation = interpretation;
        this.layout = layout;
        this.collection = collection;
        this.discardedCollection = mongodb.getCollection("discarded-" + collection.getNamespace().getCollectionName(), DBObject.class);
        this.mongoFields = mongoFields;
        this.cqlTranslator = cqlTranslator;
        this.recordInfoGenerator = recordInfoGenerator;
        this.idScheme = idScheme;
        this.idNamespace = idNamespace;
        this.metadataExtractor = metadataExtractor;
        this.recordChangeDetector = recordChangeDetector;
        this.alwaysNewRecord = alwaysNewRecord;
    }

    @Override
    public RecordInfo getRecord(String recordId) {
        Bson query = Filters.eq((String)"objIdentifier", (Object)recordId);
        DBObject result = (DBObject)this.collection.find(query).first();
        return this.recordInfoGenerator.transformDBObject(result, true);
    }

    @Override
    public RecordInfo getRecord(String recordId, Function<String, String> unaryFunction) {
        RecordInfo result = this.getRecord(recordId);
        if (result != null) {
            String transformedBody = unaryFunction.apply(result.getMetadata());
            result.setMetadata(transformedBody);
        }
        return result;
    }

    @Override
    public DNetOAIMongoCursor getRecords(String queryString, boolean bodyIncluded, int limit) {
        FindIterable<DBObject> iter = this.loggedFindByQuery(queryString, limit);
        return new DNetOAIMongoCursor((MongoCursor<DBObject>)iter.iterator(), bodyIncluded, this.recordInfoGenerator, this.metadataExtractor);
    }

    @Override
    public DNetOAIMongoCursor getRecords(String queryString, Function<String, String> unaryFunction, boolean bodyIncluded, int limit) {
        FindIterable<DBObject> iter = this.loggedFindByQuery(queryString, limit);
        return new DNetOAIMongoCursor((MongoCursor<DBObject>)iter.iterator(), unaryFunction, bodyIncluded, this.recordInfoGenerator, this.metadataExtractor);
    }

    private FindIterable<DBObject> loggedFindByQuery(String queryString, int limit) {
        Bson query = this.parseQuery(queryString);
        long start = System.currentTimeMillis();
        Bson sortByIdAsc = Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"_id"})});
        FindIterable iter = this.collection.find(query).sort(sortByIdAsc).limit(limit);
        long end = System.currentTimeMillis();
        log.debug((Object)("Query:" + query + "\ntime to get mongo iterable (ms): " + (end - start)));
        return iter;
    }

    private Bson parseQuery(String query) {
        try {
            return this.cqlTranslator.toMongo(query);
        }
        catch (Exception e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<PublisherField> getIndices() {
        return this.mongoFields;
    }

    @Override
    public void ensureIndices() {
        IndexOptions indexOptions = new IndexOptions().background(true);
        Stopwatch sw = Stopwatch.createUnstarted();
        sw.start();
        for (PublisherField field : this.mongoFields) {
            BasicDBObject mongoIdx = new BasicDBObject(field.getFieldName(), (Object)1);
            log.debug((Object)("Creating index on store " + this.id + " : " + mongoIdx));
            this.collection.createIndex((Bson)mongoIdx, indexOptions);
        }
        log.debug((Object)"Creating index over : datestamp");
        this.collection.createIndex((Bson)new BasicDBObject("datestamp", (Object)1), indexOptions);
        log.debug((Object)"Creating index over : lastCollectionDate");
        this.collection.createIndex((Bson)new BasicDBObject("lastCollectionDate", (Object)1), indexOptions);
        sw.stop();
        log.info((Object)("All indexes have been updated in " + sw.elapsed(TimeUnit.MILLISECONDS) + " milliseconds"));
    }

    public void createCompoundIndex(List<String> fieldNames) {
        if (fieldNames == null || fieldNames.isEmpty()) {
            log.fatal((Object)"No fields specified for the creation of the compound index");
        }
        BasicDBObjectBuilder theIndexBuilder = BasicDBObjectBuilder.start();
        for (String f : fieldNames) {
            theIndexBuilder.add(f, (Object)1);
        }
        BasicDBObject theIndex = (BasicDBObject)theIndexBuilder.get();
        log.info((Object)("Creating index " + theIndex + " on " + this.getId()));
        this.getCollection().createIndex((Bson)theIndex, new IndexOptions().background(true));
    }

    private void dropDiscarded(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            log.debug((Object)("Dropping discarded records from publisherStore " + this.id));
            this.discardedCollection.drop();
        } else {
            log.debug((Object)("Dropping discarded records for source " + source + " from publisherStore " + this.id));
            this.discardedCollection.deleteMany(Filters.eq((String)"set", (Object)source));
        }
    }

    @Override
    public int feed(Iterable<String> records, String source) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(80);
        Object sentinel = new Object();
        this.dropDiscarded(source);
        Date feedDate = new Date();
        Thread background = new Thread(() -> {
            MongoCollection unackCollection = this.collection.withWriteConcern(WriteConcern.UNACKNOWLEDGED);
            try {
                Object record;
                while ((record = queue.take()) != sentinel) {
                    this.safeFeedRecord((String)record, source, feedDate, (MongoCollection<DBObject>)unackCollection);
                }
            }
            catch (InterruptedException e) {
                log.fatal((Object)"got exception in background thread", (Throwable)e);
                throw new IllegalStateException(e);
            }
        });
        background.start();
        long startFeed = feedDate.getTime();
        try {
            log.info((Object)("feeding publisherStore " + this.id));
            for (String record : records) {
                queue.put(record);
            }
            queue.put(sentinel);
            log.info((Object)("finished feeding publisherStore " + this.id));
            background.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        long endFeed = System.currentTimeMillis();
        log.fatal((Object)("OAI STORE " + this.id + " FEEDING COMPLETED IN " + (endFeed - startFeed) + "ms"));
        this.setDeletedFlags(feedDate, source);
        if (StringUtils.isNotBlank((CharSequence)source)) {
            this.upsertSets(Lists.newArrayList((Object[])new String[]{source}));
        }
        return this.count();
    }

    private void setDeletedFlags(final Date feedDate, final String source) {
        final MongoCollection ackCollection = this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        Thread deletedSetter = new Thread(new Runnable(){

            @Override
            public void run() {
                Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"deleted", (Object)false), Filters.lt((String)"lastCollectionDate", (Object)feedDate)});
                if (!StringUtils.isBlank((CharSequence)source)) {
                    filter = Filters.and((Bson[])new Bson[]{filter, Filters.eq((String)"set", (Object)source)});
                }
                log.debug((Object)("Delete flag query: " + filter));
                BasicDBObject update = new BasicDBObject("$set", (Object)BasicDBObjectBuilder.start((String)"deleted", (Object)true).append("datestamp", (Object)feedDate).append("updated", (Object)true).get());
                log.debug((Object)("Updating as: " + update.toString()));
                UpdateResult updateResult = ackCollection.updateMany(filter, (Bson)update, new UpdateOptions().upsert(false));
                log.debug((Object)("Deleted flags set for source: " + source + " #records = " + updateResult.getModifiedCount()));
            }
        });
        deletedSetter.start();
        try {
            deletedSetter.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void drop() {
        this.collection.drop();
    }

    @Override
    public void drop(String queryString) {
        Bson query = this.parseQuery(queryString);
        DeleteResult deleteResult = this.collection.deleteMany(query);
        log.debug((Object)("Deleted by query: " + queryString + " #deleted: " + deleteResult.getDeletedCount()));
    }

    @Override
    public int count() {
        return (int)this.collection.count();
    }

    @Override
    public int count(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return (int)this.collection.count();
        }
        Bson query = this.parseQuery(queryString);
        return (int)this.collection.count(query);
    }

    public List<String> getDistinctSetNamesFromRecords() {
        log.info((Object)("Going to ask for all distinct sets in the oaistore " + this.id + ": this may take a long time..."));
        return Lists.newArrayList((Iterable)this.collection.distinct("set", String.class));
    }

    private boolean safeFeedRecord(String record, String source, Date feedDate, MongoCollection<DBObject> unackCollection) {
        try {
            if (!record.isEmpty()) {
                return this.feedRecord(record, source, feedDate, unackCollection);
            }
        }
        catch (Throwable e) {
            log.error((Object)"Got unhandled exception while parsing record", e);
            this.discardedCollection.insertOne((Object)new BasicDBObject("set", (Object)source).append("body", (Object)record));
        }
        return false;
    }

    private boolean feedRecord(String record, String source, Date feedDate, MongoCollection<DBObject> unackCollection) {
        PublisherRecordParser parser = new PublisherRecordParser(this.mongoFields);
        log.debug((Object)("configured parser for fields: " + this.mongoFields));
        Multimap<String, String> recordProperties = parser.parseRecord(record, source);
        if (recordProperties.containsKey((Object)"objIdentifier")) {
            String id = (String)recordProperties.get((Object)"objIdentifier").iterator().next();
            String oaiID = this.getOAIIdentifier(id);
            if (this.isNewRecord(oaiID)) {
                this.feedNew(oaiID, record, recordProperties, feedDate, unackCollection);
                return true;
            }
            if (this.isChanged(oaiID, record)) {
                this.updateRecord(oaiID, record, recordProperties, feedDate, unackCollection);
            } else {
                this.handleRecord(oaiID, feedDate, unackCollection);
            }
        } else {
            log.error((Object)"parsed record seems invalid -- no identifier property with name: objIdentifier");
            log.error((Object)("Extracted property map: \n" + recordProperties));
            log.debug((Object)("from: \n" + record));
            this.discardedCollection.insertOne((Object)new BasicDBObject("set", (Object)source).append("body", (Object)record).append("datestamp", (Object)feedDate));
        }
        return false;
    }

    private BasicDBObject createBasicObject(String oaiID, String record, Multimap<String, String> recordProperties) {
        BasicDBObject obj = new BasicDBObject();
        for (String key : recordProperties.keySet()) {
            if (key.equals("objIdentifier")) {
                obj.put((Object)key, (Object)oaiID);
                continue;
            }
            Collection values = recordProperties.get((Object)key);
            if (key.equals("set")) {
                Iterable setSpecs = values.stream().map(s -> this.mongoSetCollection.normalizeSetSpec((String)s)).collect(Collectors.toList());
                obj.put((Object)key, (Object)setSpecs);
                continue;
            }
            PublisherField keyField = (PublisherField)Iterables.find(this.mongoFields, field -> field.getFieldName().equals(key), null);
            if (keyField == null) {
                log.warn((Object)("Expected field to index: " + key + " could not be found, but we keep going..."));
            }
            if (keyField != null && !keyField.isRepeatable()) {
                if (values == null || values.isEmpty()) continue;
                obj.put((Object)key, values.iterator().next());
                continue;
            }
            obj.put((Object)key, (Object)values);
        }
        try {
            obj.put((Object)"body", (Object)this.createCompressRecord(record));
            obj.put((Object)"deleted", (Object)false);
            return obj;
        }
        catch (IOException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    public Binary createCompressRecord(String record) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(os);
        ZipEntry entry = new ZipEntry("body");
        zos.putNextEntry(entry);
        zos.write(record.getBytes());
        zos.closeEntry();
        zos.flush();
        zos.close();
        return new Binary(os.toByteArray());
    }

    private void feedNew(String oaiID, String record, Multimap<String, String> recordProperties, Date feedDate, MongoCollection<DBObject> unackCollection) {
        log.debug((Object)("New record received. Assigned oai id: " + oaiID));
        BasicDBObject obj = this.createBasicObject(oaiID, record, recordProperties);
        obj.put("lastCollectionDate", (Object)feedDate);
        obj.put("datestamp", (Object)feedDate);
        obj.put("updated", (Object)false);
        unackCollection.insertOne((Object)obj);
        this.upsertSets(recordProperties.get((Object)"set"));
    }

    private void updateRecord(String oaiID, String record, Multimap<String, String> recordProperties, Date feedDate, MongoCollection<DBObject> unackCollection) {
        log.debug((Object)("updating record " + oaiID));
        BasicDBObject obj = this.createBasicObject(oaiID, record, recordProperties);
        obj.put((Object)"lastCollectionDate", (Object)feedDate);
        obj.put((Object)"datestamp", (Object)feedDate);
        obj.put((Object)"updated", (Object)true);
        Bson oldObj = Filters.eq((String)"objIdentifier", (Object)oaiID);
        unackCollection.replaceOne(oldObj, (Object)obj, new UpdateOptions().upsert(true));
        this.upsertSets(recordProperties.get((Object)"set"));
    }

    public void upsertSets(Iterable<String> setNames) {
        if (setNames != null) {
            for (String setName : setNames) {
                if (!StringUtils.isNotBlank((CharSequence)setName)) continue;
                SetInfo set = new SetInfo();
                String setSpec = this.mongoSetCollection.normalizeSetSpec(setName);
                set.setSetSpec(setSpec);
                set.setSetName(setName);
                set.setSetDescription("This set contains metadata records whose provenance is " + setName);
                set.setEnabled(true);
                String query = "(set = \"" + setSpec + "\") ";
                set.setQuery(query);
                this.mongoSetCollection.upsertSet(set, false, this.getCollection().getNamespace().getDatabaseName());
            }
        }
    }

    private void handleRecord(String oaiID, Date lastCollectionDate, MongoCollection<DBObject> unackCollection) {
        log.debug((Object)("handling unchanged record " + oaiID));
        Bson oldObj = Filters.eq((String)"objIdentifier", (Object)oaiID);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("lastCollectionDate", (Object)lastCollectionDate));
        unackCollection.updateOne(oldObj, (Bson)update, new UpdateOptions().upsert(true));
    }

    private boolean isNewRecord(String oaiIdentifier) {
        if (this.alwaysNewRecord || this.collection.count() == 0L) {
            return true;
        }
        return this.collection.find(Filters.eq((String)"objIdentifier", (Object)oaiIdentifier)).first() == null;
    }

    private boolean isChanged(String oaiID, String record) {
        RecordInfo oldRecord = this.getRecord(oaiID);
        if (oldRecord == null) {
            return StringUtils.isBlank((CharSequence)record);
        }
        return this.recordChangeDetector.differs(oldRecord.getMetadata(), record);
    }

    private String getOAIIdentifier(String id) {
        return this.idScheme + ":" + this.idNamespace + ":" + id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.interpretation == null ? 0 : this.interpretation.hashCode());
        result = 31 * result + (this.layout == null ? 0 : this.layout.hashCode());
        result = 31 * result + (this.metadataFormat == null ? 0 : this.metadataFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoPublisherStore)) {
            return false;
        }
        MongoPublisherStore other = (MongoPublisherStore)obj;
        if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.interpretation == null ? other.interpretation != null : !this.interpretation.equals(other.interpretation)) {
            return false;
        }
        if (this.layout == null ? other.layout != null : !this.layout.equals(other.layout)) {
            return false;
        }
        return !(this.metadataFormat == null ? other.metadataFormat != null : !this.metadataFormat.equals(other.metadataFormat));
    }

    public MongoCollection<DBObject> getCollection() {
        return this.collection;
    }

    public void setCollection(MongoCollection<DBObject> collection) {
        this.collection = collection;
    }

    public MongoCollection<DBObject> getDiscardedCollection() {
        return this.discardedCollection;
    }

    public void setDiscardedCollection(MongoCollection<DBObject> discardedCollection) {
        this.discardedCollection = discardedCollection;
    }

    public String getIdScheme() {
        return this.idScheme;
    }

    public void setIdScheme(String idScheme) {
        this.idScheme = idScheme;
    }

    public String getIdNamespace() {
        return this.idNamespace;
    }

    public void setIdNamespace(String idNamespace) {
        this.idNamespace = idNamespace;
    }

    public RecordInfoGenerator getRecordInfoGenerator() {
        return this.recordInfoGenerator;
    }

    public void setRecordInfoGenerator(RecordInfoGenerator recordInfoGenerator) {
        this.recordInfoGenerator = recordInfoGenerator;
    }

    public MetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    public void setMetadataExtractor(MetadataExtractor metadataExtractor) {
        this.metadataExtractor = metadataExtractor;
    }

    public RecordChangeDetector getRecordChangeDetector() {
        return this.recordChangeDetector;
    }

    public void setRecordChangeDetector(RecordChangeDetector recordChangeDetector) {
        this.recordChangeDetector = recordChangeDetector;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    @Override
    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    @Override
    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public List<PublisherField> getMongoFields() {
        return this.mongoFields;
    }

    public void setMongoFields(List<PublisherField> mongoFields) {
        this.mongoFields = mongoFields;
    }

    public boolean isAlwaysNewRecord() {
        return this.alwaysNewRecord;
    }

    public void setAlwaysNewRecord(boolean alwaysNewRecord) {
        this.alwaysNewRecord = alwaysNewRecord;
    }
}

