package eu.dnetlib.data.cleaner.inspector;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import eu.dnetlib.data.cleaner.CleaningRule;
import eu.dnetlib.data.cleaner.CleaningRuleFactory;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.rmi.data.CleanerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CleanerInspector extends AbstractInspectorController {

	@Autowired
	private CleaningRuleFactory cleaningRuleFactory;

	@RequestMapping(value = "/inspector/cleaner.do")
	public void cleaner(final Model model,
			@RequestParam(value = "rule", required = false) final String ruleId,
			@RequestParam(value = "dirtyText", required = false) final String dirtyText) throws CleanerException {

		final List<String> rules = Lists.newArrayList(this.cleaningRuleFactory.getRuleIds());
		model.addAttribute("rules", selectOptions(rules, ruleId));

		if ((ruleId != null) && (dirtyText != null)) {
			final CleaningRule rule = this.cleaningRuleFactory.obtainCleaningRule(ruleId);
			model.addAttribute("dirtyText", dirtyText);
			model.addAttribute("cleanedText", rule.apply(dirtyText));
		}
	}

	/**
	 * Given an list of values, return a list of SelectOption instances which have the "selected" boolean field set to true only for the
	 * element matching "current".
	 *
	 * @param input
	 *            list of input strings
	 * @param current
	 *            current value to select
	 * @return
	 */
	private List<SelectOption> selectOptions(final List<String> input, final String current) {
		return input.stream()
				.map(it -> new SelectOption(it, it.equals(current)))
				.collect(Collectors.toList());
	}

	public static class SelectOption {

		private String value;
		private boolean selected;

		public SelectOption(final String value, final boolean selected) {
			super();
			this.value = value;
			this.selected = selected;
		}

		public String getValue() {
			return this.value;
		}

		public void setValue(final String value) {
			this.value = value;
		}

		public boolean isSelected() {
			return this.selected;
		}

		public void setSelected(final boolean selected) {
			this.selected = selected;
		}
	}

}
