package eu.dnetlib.data.collector.plugins.sftp;

import java.util.Set;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;

/**
 * Created by andrea on 11/01/16.
 */
public class SftpCollectorPlugin extends AbstractSftpCollectorPlugin {

	@Override
	protected Iterable<String> getIterable(final InterfaceDescriptor interfaceDescriptor,
			final String baseUrl,
			final boolean isRecursive,
			final Set<String> extensionSet,
			final String fromDate) throws CollectorServiceException {

		final String username = interfaceDescriptor.getParams().get("username");
		final String password = interfaceDescriptor.getParams().get("password");

		if ((username == null) || username.isEmpty()) {
			throw new CollectorServiceException("Param 'username' is null or empty");
		}
		if ((password == null) || password.isEmpty()) {
			throw new CollectorServiceException("Param 'password' is null or empty");
		}
		return () -> getSftpIteratorFactory().newIteratorSimplAuth(baseUrl, username, password, isRecursive, extensionSet, fromDate);
	}
}
