package eu.dnetlib.data.objectstore;

import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.rmi.data.DownloadPlugin;
import eu.dnetlib.rmi.data.DownloadPluginEnumerator;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

/**
 * The Class DownloadPluginEnumeratorImpl.
 */
public class DownloadPluginEnumeratorImpl implements DownloadPluginEnumerator {

	/**
	 * bean factory.
	 */
	private ListableBeanFactory beanFactory;

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.download.rmi.DownloadPluginEnumerator#getAll()
	 */
	@Override
	public Map<String, DownloadPlugin> getAll() {
		return beanFactory.getBeansOfType(DownloadPlugin.class);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.data.download.rmi.DownloadPluginEnumerator#getByProtocols()
	 */
	@Override
	public Map<String, DownloadPlugin> getByProtocols() {
		final Map<String, DownloadPlugin> res = new HashMap<>();
		for (DownloadPlugin cp : getAll().values()) {
			res.put(cp.getPluginName().toLowerCase(), cp);
		}
		return res;
	}

	/**
	 * Gets the bean factory.
	 *
	 * @return the bean factory
	 */
	public ListableBeanFactory getBeanFactory() {
		return beanFactory;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.springframework.beans.factory.BeanFactoryAware#setBeanFactory(org.springframework.beans.factory.BeanFactory)
	 */
	@Override
	public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
		this.beanFactory = (ListableBeanFactory) beanFactory;
	}

	/**
	 * Get given DownloadPlugin or throws exception.
	 *
	 * @param protocol the protocol
	 * @return the download plugin
	 * @throws eu.dnetlib.rmi.data.ObjectStoreServiceException the download service exception
	 */
	public DownloadPlugin get(final String protocol) throws ObjectStoreServiceException {
		final DownloadPlugin plugin = getByProtocols().get(protocol.toLowerCase());
		if (plugin == null) throw new ObjectStoreServiceException("plugin not found for name: " + protocol);
		return plugin;
	}

}
