/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.AbstractObjectStoreAction;
import eu.dnetlib.data.objectstore.ModularObjectStoreFeeder;
import eu.dnetlib.data.objectstore.ObjectStoreProfileCreator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import eu.dnetlib.rmi.data.Protocols;
import org.springframework.beans.factory.annotation.Required;

public class FeedObjectStoreAction
extends AbstractObjectStoreAction {
    private ObjectStoreProfileCreator profileCreator;
    private ModularObjectStoreFeeder storeFeeder;

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws ObjectStoreServiceException {
        try {
            String objStoreID = (String)job.getParameters().get("obsID");
            String objID = (String)job.getParameters().get("objID");
            String URI2 = (String)job.getParameters().get("URI");
            String eprRs = (String)job.getParameters().get("epr");
            String protocolString = (String)job.getParameters().get("protocol");
            Protocols protocol = protocolString == null ? Protocols.None : Protocols.valueOf((String)((String)job.getParameters().get("protocol")));
            String mime = (String)job.getParameters().get("mime");
            String login = (String)job.getParameters().get("login");
            String password = (String)job.getParameters().get("password");
            if (URI2 != null && URI2.length() > 0) {
                this.storeFeeder.feedObject(objStoreID, objID, URI2, protocol, login, password, mime);
            } else if (eprRs != null && eprRs.length() > 0) {
                this.storeFeeder.feed(objStoreID, eprRs, protocol, login, password, mime);
            }
            this.completeWithSuccess(handler, job);
        }
        catch (Exception e) {
            this.completeWithFail(handler, job, e);
        }
    }

    public ObjectStoreProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    @Required
    public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
    }

    public ModularObjectStoreFeeder getStoreFeeder() {
        return this.storeFeeder;
    }

    @Required
    public void setStoreFeeder(ModularObjectStoreFeeder storeFeeder) {
        this.storeFeeder = storeFeeder;
    }
}

