/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.functions;

import eu.dnetlib.data.collective.transformation.engine.functions.AbstractTransformationFunction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;

public class RegularExpression
extends AbstractTransformationFunction {
    public static final Log log = LogFactory.getLog(RegularExpression.class);
    public static final String paramRegularExpr = "regularExpression";
    public static final String paramExpr1 = "expr1";
    public static final String paramExpr2 = "expr2";
    private Perl5Util util = new Perl5Util();

    @Override
    String execute() throws ProcessingException {
        return null;
    }

    public String executeSingleValue(String aRegularExpression, String aExpr1, String aExpr2) throws ProcessingException {
        String result = "";
        if (aRegularExpression.startsWith("m/")) {
            if (this.util.match(aRegularExpression, aExpr1)) {
                result = this.util.group(1);
            }
        } else if (!aRegularExpression.startsWith("s/")) {
            if (this.util.match(aRegularExpression, aExpr1)) {
                String funder = this.util.group(1).toLowerCase();
                String projectId = this.util.group(3);
                result = funder + "_" + projectId;
            }
        } else {
            try {
                result = this.util.substitute(aRegularExpression, aExpr1);
            }
            catch (MalformedPerl5PatternException patternExc) {
                log.fatal((Object)("aRegularExpression: " + aRegularExpression));
                log.fatal((Object)("aExpr1: " + aExpr1));
                log.fatal((Object)patternExc.getMessage());
                throw new ProcessingException(patternExc);
            }
        }
        return result;
    }
}

