/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.ObjectBroker;
import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MetadataObjectRecord;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import eu.dnetlib.rmi.data.Protocols;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreFeeder {
    private static final Log log = LogFactory.getLog(ModularObjectStoreFeeder.class);
    private ObjectStoreDao dao;
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public ObjectStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(ObjectStoreDao dao) {
        this.dao = dao;
    }

    public int feedMetadataObjectRecord(String objectStoreID, String rsEpr, String mime) throws ObjectStoreServiceException {
        Iterable records = this.resultSetClient.iter(ResultSet.fromJson((String)rsEpr), MetadataObjectRecord.class);
        Stream<MetadataObjectRecord> toIngest = DnetStreamSupport.generateStreamFromIterator(records.iterator()).map(record -> {
            if (record != null) {
                record.setMime(mime);
            } else {
                log.error((Object)("An input record is null :" + record.toString()));
            }
            return record;
        });
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        int size = store.feedMetadataRecord(toIngest::iterator, true);
        this.touch(objectStoreID, size);
        return size;
    }

    public void feed(String obsId, String rsEpr, Protocols protocol, String login, String password, String mime) throws ObjectStoreServiceException {
        Iterable records = this.resultSetClient.iter(ResultSet.fromJson((String)rsEpr), ObjectStoreRecord.class);
        ObjectBroker objectBroker = new ObjectBroker(protocol, login, password, mime);
        ObjectStore store = this.dao.getObjectStore(obsId);
        int size = store.feed(DnetStreamSupport.generateStreamFromIterator(records.iterator()).map(objectBroker)::iterator, true);
        this.touch(obsId, size);
    }

    public void feedObject(String objectStoreID, String objectID, String URIObject, Protocols protocol, String login, String password, String mime) throws ObjectStoreServiceException {
        ObjectStoreRecord inputFile = new ObjectStoreRecord();
        inputFile.setFileMetadata(new ObjectStoreFile());
        inputFile.getFileMetadata().setURI(URIObject);
        inputFile.getFileMetadata().setObjectID(objectID);
        ObjectBroker objectBroker = new ObjectBroker(protocol, login, password, mime);
        List<ObjectStoreRecord> toIngest = Arrays.asList(inputFile).stream().map(objectBroker).collect(Collectors.toList());
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        int size = store.feed(toIngest, true);
        this.touch(objectStoreID, size);
    }

    public String feedObjectRecord(String objectStoreID, ObjectStoreRecord record) throws ObjectStoreServiceException {
        ObjectStore store = this.dao.getObjectStore(objectStoreID);
        return store.feedObjectRecord(record);
    }

    public void touch(String obsId, int size) {
        try {
            String now = DateUtils.now_ISO8601();
            String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + obsId + "']return update value $x//LAST_STORAGE_DATE with '" + now + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true)).executeXUpdate(mdstoreXUpdate);
            this.touchSize(obsId, size);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void touchSize(String obsId, int size) {
        try {
            String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + obsId + "']return update value $x//COUNT_STORE with '" + size + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class, true)).executeXUpdate(mdstoreNumberXUpdate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

