/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.ftp;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.plugins.ftp.FtpIteratorFactory;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public class FtpCollectorPlugin
extends AbstractCollectorPlugin {
    private FtpIteratorFactory ftpIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String username = (String)interfaceDescriptor.getParams().get("username");
        final String password = (String)interfaceDescriptor.getParams().get("password");
        final String recursive = (String)interfaceDescriptor.getParams().get("recursive");
        final String extensions = (String)interfaceDescriptor.getParams().get("extensions");
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (password == null || password.isEmpty()) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (recursive == null || recursive.isEmpty()) {
            throw new CollectorServiceException("Param 'recursive' is null or empty");
        }
        if (extensions == null || extensions.isEmpty()) {
            throw new CollectorServiceException("Param 'extensions' is null or empty");
        }
        return new Iterable<String>(){
            boolean isRecursive;
            Set<String> extensionsSet;
            {
                this.isRecursive = "true".equals(recursive);
                this.extensionsSet = this.parseSet(extensions);
            }

            @Override
            public Iterator<String> iterator() {
                return FtpCollectorPlugin.this.getFtpIteratorFactory().newIterator(baseUrl, username, password, this.isRecursive, this.extensionsSet);
            }

            private Set<String> parseSet(String extensions2) {
                return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)extensions2));
            }
        };
    }

    public FtpIteratorFactory getFtpIteratorFactory() {
        return this.ftpIteratorFactory;
    }

    @Required
    public void setFtpIteratorFactory(FtpIteratorFactory ftpIteratorFactory) {
        this.ftpIteratorFactory = ftpIteratorFactory;
    }
}

