package eu.dnetlib.data.mdstore.modular.mongodb.utils;

import java.util.Comparator;
import java.util.Date;
import java.util.function.Function;
import java.util.function.Predicate;

import com.mongodb.DBObject;

public class MDStoreUtils {

	public static Function<DBObject, String> mdId() {
		return arg -> (String) arg.get("mdId");
	}

	public static Predicate<DBObject> dboFilter(final String format, final String layout, final String interpretation) {
		return dbo -> dbo.get("format").toString().equals(format) && dbo.get("layout").toString().equals(layout)
				&& dbo.get("interpretation").toString().equals(interpretation);
	}

	public static Function<DBObject, String> body() {
		return arg -> (String) arg.get("body");
	}

	public static Comparator<DBObject> getComparatorOnDate() {
		return (o1, o2) -> {
			Date d1 = (Date) o1.get("date");
			Date d2 = (Date) o2.get("date");
			return d1.compareTo(d2);
		};
	}
}
