/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.cleaner;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.cleaner.CleaningRule;
import eu.dnetlib.data.cleaner.GroovyRule;
import eu.dnetlib.data.cleaner.VocabularyRule;
import eu.dnetlib.data.cleaner.XPATHCleaningRule;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.data.CleanerException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class CleaningRuleFactory {
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public CleaningRule obtainCleaningRule(String ruleId) throws CleanerException {
        try {
            String prof = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + ruleId + "' or .//CLEANER_NAME='" + ruleId + "']//CONFIGURATION");
            SAXReader reader = new SAXReader();
            Document doc = reader.read((Reader)new StringReader(prof));
            CleaningRule rule = new CleaningRule();
            ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
            for (Object o : doc.selectNodes("//RULE")) {
                XPATHCleaningRule xpathRule;
                Element node = (Element)o;
                String xpath = node.valueOf("@xpath");
                String vocabularies = node.valueOf("@vocabularies");
                String groovyRule = node.valueOf("@groovy");
                String strict = node.valueOf("@strict");
                if (vocabularies != null && vocabularies.length() > 0) {
                    HashSet list = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)vocabularies));
                    xpathRule = new VocabularyRule(list, lookup);
                } else {
                    xpathRule = new GroovyRule(groovyRule);
                }
                xpathRule.setXpath(xpath);
                xpathRule.setStrict("true".equals(strict));
                rule.getXpathRules().add(xpathRule);
            }
            return rule;
        }
        catch (Exception e) {
            throw new CleanerException("Error obtaing cleaner rule " + ruleId, (Throwable)e);
        }
    }

    public List<String> getRuleIds() throws CleanerException {
        try {
            HashSet response = new HashSet();
            List list = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("//CLEANER_NAME");
            if (list != null) {
                response.addAll(list);
            }
            return Lists.newArrayList(response);
        }
        catch (ISLookUpException e) {
            throw new CleanerException("Error obtaining IDs of cleaner DSs", (Throwable)e);
        }
    }
}

