/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.ObjectStoreActions;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractObjectStoreAction
implements BlackboardServerAction<ObjectStoreActions> {
    private static final Log log = LogFactory.getLog(AbstractObjectStoreAction.class);
    private final Executor executor = Executors.newCachedThreadPool();
    private ObjectStoreDao dao;

    protected abstract void executeAsync(BlackboardServerHandler var1, BlackboardJob var2) throws ObjectStoreServiceException;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) {
        this.executor.execute(() -> {
            try {
                handler.ongoing(job);
                this.executeAsync(handler, job);
            }
            catch (ObjectStoreServiceException e) {
                handler.failed(job, (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeWithSuccess(BlackboardServerHandler handler, BlackboardJob job) {
        AbstractObjectStoreAction abstractObjectStoreAction = this;
        synchronized (abstractObjectStoreAction) {
            handler.done(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeWithFail(BlackboardServerHandler handler, BlackboardJob job, Throwable e) {
        AbstractObjectStoreAction abstractObjectStoreAction = this;
        synchronized (abstractObjectStoreAction) {
            handler.failed(job, e);
        }
    }

    public ObjectStoreDao getDao() {
        return this.dao;
    }

    public void setDao(ObjectStoreDao dao) {
        this.dao = dao;
    }
}

