/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.utils;

import eu.dnetlib.common.utils.XMLException;
import eu.dnetlib.common.utils.XMLUtils;
import java.io.StringReader;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.log4j.Logger;
import org.dom4j.Node;
import org.dom4j.io.DocumentResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EprUtils {
    public static final String INDEX_RESULT_SET_NAME = "ICMResultSet";
    public static final String SERVICE_NAME = "IndexService";
    protected static final Logger log = Logger.getLogger(EprUtils.class);
    private DocumentResult infoset = new DocumentResult();

    public EprUtils(W3CEndpointReference epr, Map<String, String> nsMap) {
        epr.writeTo((Result)this.infoset);
        XMLUtils.setNamespaces(nsMap);
    }

    @Deprecated
    public static String[] parseResultSetEPR(String resultSetEPR) {
        if (resultSetEPR == null || resultSetEPR.length() == 0) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setValidating(false);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(resultSetEPR)));
            Element documentElement = doc.getDocumentElement();
            NodeList nodeList = documentElement.getElementsByTagName("ResourceIdentifier:ResourceIdentifier");
            if (nodeList.getLength() != 1) {
                log.error((Object)("Invalid notifications of nodes for driver:ResourceIdentifier element. Expected 1, found: " + nodeList.getLength()));
                return null;
            }
            if (nodeList.item(0) == null) {
                log.error((Object)"Couldn't find ResourceIdentifier:ResourceIdentifier element!");
                return null;
            }
            NodeList nodeListWSA = documentElement.getElementsByTagName("Address");
            if (nodeListWSA.getLength() != 1 && (nodeListWSA = documentElement.getElementsByTagName("Address")).getLength() != 1) {
                log.error((Object)("Invalid notifications of nodes for Address element. Expected 1, found: " + nodeListWSA.getLength()));
                return null;
            }
            if (nodeListWSA.item(0) == null) {
                log.error((Object)"Couldn't find Address element!");
                return null;
            }
            return new String[]{EprUtils.getStringFromNode(nodeListWSA.item(0)), EprUtils.getStringFromNode(nodeList.item(0))};
        }
        catch (Exception e) {
            log.error((Object)"Exception occured when extracting ResultSet id from ResultSet service xml-type response!", (Throwable)e);
            return null;
        }
    }

    public static String extractResultSetId(String sourceResultSetId) {
        if (sourceResultSetId == null || sourceResultSetId.length() == 0) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setValidating(false);
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(sourceResultSetId)));
            Element documentElement = doc.getDocumentElement();
            NodeList nodeList = documentElement.getElementsByTagName("ResourceIdentifier:ResourceIdentifier");
            if (nodeList.getLength() != 1) {
                log.error((Object)("Invalid notifications of nodes for ResourceIdentifier:ResourceIdentifier element. Expected 1, found: " + nodeList.getLength()));
                return null;
            }
            if (nodeList.item(0) == null) {
                log.error((Object)"Couldn't find ResourceIdentifier:ResourceIdentifier element!");
                return null;
            }
            return EprUtils.getStringFromNode(nodeList.item(0));
        }
        catch (Exception e) {
            log.error((Object)"Exception occured when extracting ResultSet id from ResultSet service xml-type response!", (Throwable)e);
            return null;
        }
    }

    private static String getStringFromNode(org.w3c.dom.Node node) {
        return node.getFirstChild().getNodeValue();
    }

    public static String buildResultSetEPR(String serviceAddress, String resultSetId, String wsdlLocation) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        strBuff.append("<wsa:EndpointReference xmlns:wsa=\"http://www.driver.org/schema\" xmlns:driver=\"http://www.driver.org\" xmlns:wsaw=\"http://www.w3.org/2006/02/addressing/wsdl\" xmlns:wsdl=\"http://www.w3.org/2005/08/wsdl-instance\">");
        strBuff.append("<Address>");
        strBuff.append(serviceAddress);
        strBuff.append("</Address>");
        strBuff.append("<wsa:ReferenceParameters>");
        strBuff.append("<ResourceIdentifier:ResourceIdentifier>");
        strBuff.append(resultSetId);
        strBuff.append("</ResourceIdentifier:ResourceIdentifier>");
        strBuff.append("</wsa:ReferenceParameters>");
        strBuff.append("<wsa:Metadata wsdl:wsdlLocation=\"" + wsdlLocation + "\">");
        strBuff.append("<wsaw:ServiceName>");
        strBuff.append(INDEX_RESULT_SET_NAME);
        strBuff.append("</wsaw:ServiceName>");
        strBuff.append("</wsa:Metadata>");
        strBuff.append("</wsa:EndpointReference>");
        return strBuff.toString();
    }

    public static W3CEndpointReference buildW3CEPR(String serviceAddress, String wsdlLocation) throws ParserConfigurationException {
        W3CEndpointReferenceBuilder W3CResultSetEPR = new W3CEndpointReferenceBuilder();
        W3CResultSetEPR.address(serviceAddress);
        W3CResultSetEPR.serviceName(new QName("http://www.w3.org/2006/02/addressing/wsdl", SERVICE_NAME));
        W3CResultSetEPR.endpointName(new QName("http://www.driver.org/schema", SERVICE_NAME));
        W3CResultSetEPR.wsdlDocumentLocation(wsdlLocation);
        return W3CResultSetEPR.build();
    }

    public String getValue(String xpathExpr) throws XMLException {
        return XMLUtils.evaluate((Node)this.infoset.getDocument(), xpathExpr);
    }
}

