/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.cleaner;

import eu.dnetlib.data.cleaner.XPATHCleaningRule;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class CleaningRule
implements Function<String, String> {
    private static final Log log = LogFactory.getLog(CleaningRule.class);
    private List<XPATHCleaningRule> xpathRules = new ArrayList<XPATHCleaningRule>();

    @Override
    public String apply(String text) {
        try {
            ArrayList<Map<String, String>> errors = new ArrayList<Map<String, String>>();
            Document doc = new SAXReader().read((Reader)new StringReader(text));
            for (XPATHCleaningRule r : this.xpathRules) {
                errors.addAll(r.applyXpathRule(doc));
            }
            if (errors.size() > 0) {
                this.markAsInvalid(doc, errors);
            }
            return doc.asXML();
        }
        catch (Exception e) {
            log.error((Object)"Error evaluating rule", (Throwable)e);
            return "";
        }
    }

    private void markAsInvalid(Document doc, List<Map<String, String>> errors) {
        Element element = (Element)doc.selectSingleNode("//*[local-name()='header']");
        if (element != null) {
            Element inv = element.addElement(new QName("invalid", new Namespace("dri", "http://www.driver-repository.eu/namespace/dri")));
            for (Map<String, String> e : errors) {
                Element err = inv.addElement(new QName("error", new Namespace("dri", "http://www.driver-repository.eu/namespace/dri")));
                for (Map.Entry<String, String> entry : e.entrySet()) {
                    err.addAttribute(entry.getKey(), entry.getValue());
                }
            }
            inv.addAttribute("value", "true");
        }
    }

    public List<XPATHCleaningRule> getXpathRules() {
        return this.xpathRules;
    }

    @Required
    public void setXpathRules(List<XPATHCleaningRule> xpathRules) {
        this.xpathRules = xpathRules;
    }
}

