/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.data.collector.plugins.oai.OaiIteratorFactory;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.beans.factory.annotation.Required;

public class OaiCollectorPlugin
extends AbstractCollectorPlugin {
    private static final String FORMAT_PARAM = "format";
    private static final String OAI_SET_PARAM = "set";
    private OaiIteratorFactory oaiIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String mdFormat = (String)interfaceDescriptor.getParams().get(FORMAT_PARAM);
        String setParam = (String)interfaceDescriptor.getParams().get(OAI_SET_PARAM);
        ArrayList<String> sets = new ArrayList<String>();
        if (setParam != null) {
            sets.addAll(Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)setParam)));
        }
        if (sets.isEmpty()) {
            sets.add("");
        }
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (mdFormat == null || mdFormat.isEmpty()) {
            throw new CollectorServiceException("Param 'mdFormat' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        if (untilDate != null && !untilDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + untilDate);
        }
        return () -> {
            Iterator iterator = sets.stream().map(set -> this.oaiIteratorFactory.newIterator(baseUrl, mdFormat, (String)set, fromDate, untilDate)).iterator();
            return Iterators.concat(iterator);
        };
    }

    public OaiIteratorFactory getOaiIteratorFactory() {
        return this.oaiIteratorFactory;
    }

    @Required
    public void setOaiIteratorFactory(OaiIteratorFactory oaiIteratorFactory) {
        this.oaiIteratorFactory = oaiIteratorFactory;
    }
}

