/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.data.objectstore.ObjectStoreIntegrityInfo;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ObjectStoreConsistency {
    private static final Log log = LogFactory.getLog(ObjectStoreConsistency.class);
    @Autowired
    private ObjectStoreDao objectStoreDao;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private ObjectStoreIntegrityInfo integrityInfo;

    @RequestMapping(value={"/ui/objectStore/infoConsistency.do"})
    @ResponseBody
    public ObjectStoreIntegrityInfo getConsistencyInfo(ModelMap map) {
        return this.getIntegrityInfo();
    }

    public void refreshConsistency() {
        try {
            Set<String> profiles = this.listProfileIds();
            Set<String> objectStore = this.listObjectStoreIds();
            HashSet objectStoreNotInProfile = Sets.newHashSet(objectStore);
            objectStoreNotInProfile.removeAll(profiles);
            HashSet profilesNotInObjectStore = Sets.newHashSet(profiles);
            profilesNotInObjectStore.removeAll(objectStore);
            ObjectStoreIntegrityInfo info = new ObjectStoreIntegrityInfo();
            info.setObjectStoreWithoutProfile(objectStoreNotInProfile);
            info.setProfileWithoutObjectStore(profilesNotInObjectStore);
            this.integrityInfo = info;
        }
        catch (ISLookUpException e) {
            log.error((Object)"Error on refreshing consistency of objectStore ", (Throwable)e);
        }
    }

    private Set<String> listObjectStoreIds() {
        return Sets.newHashSet((Iterable)Lists.transform(this.objectStoreDao.listObjectStores(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return StringUtils.substringBefore((String)input, (String)"_");
            }
        }));
    }

    private Set<String> listProfileIds() throws ISLookUpException {
        ISLookUpService lookupService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String query = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()";
        List resultList = lookupService.quickSearchProfile("for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') return $x//RESOURCE_IDENTIFIER/@value/string()");
        return Sets.newHashSet((Iterable)Lists.transform((List)resultList, (Function)new Function<String, String>(){

            public String apply(String input) {
                return StringUtils.substringBefore((String)input, (String)"_");
            }
        }));
    }

    public ObjectStoreIntegrityInfo getIntegrityInfo() {
        if (this.integrityInfo == null) {
            this.refreshConsistency();
        }
        return this.integrityInfo;
    }

    public void setIntegrityInfo(ObjectStoreIntegrityInfo integrityInfo) {
        this.integrityInfo = integrityInfo;
    }
}

