package eu.dnetlib.data.collector.plugins;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

import com.google.common.collect.Lists;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import org.apache.commons.io.IOUtils;

/**
 * Collects whatever is in the given baseUrl. If you have multiple records to be splitted, then use eu.dnetlib.data.collector.plugins.HttpCollectorPlugin.
 * If you have a CSV file, then prefer eu.dnetlib.data.collector.plugins.HttpCSVCollectorPlugin .
 */
public class HttpSimpleCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {

		URL url = null;
		try {
			url = new URL(interfaceDescriptor.getBaseUrl());
			return Lists.newArrayList(IOUtils.toString(url, Charset.forName("UTF-8")));

		} catch (IOException e) {
			throw new CollectorServiceException("Cannot download from URL: " + url, e);
		}
	}
}
