/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oaisets;

import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.HttpConnector;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.rmi.data.CollectorServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class OaiSetsIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(OaiSetsIterator.class);
    private Queue<String> queue = new PriorityBlockingQueue<String>();
    private SAXReader reader = new SAXReader();
    private String baseUrl;
    private String token;
    private boolean started;
    private HttpConnector httpConnector;
    private Set<String> setsAlreadySeen = Sets.newHashSet();

    public OaiSetsIterator(String baseUrl, HttpConnector httpConnector) {
        this.baseUrl = baseUrl;
        this.started = false;
        this.httpConnector = httpConnector;
    }

    private void verifyStarted() {
        if (!this.started) {
            this.started = true;
            try {
                this.token = this.firstPage();
            }
            catch (CollectorServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doHasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.token != null && !this.token.isEmpty()) {
                try {
                    this.token = this.otherPages(this.token);
                }
                catch (CollectorServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return res;
        }
    }

    private String firstPage() throws CollectorServiceException {
        String url = this.baseUrl + "?verb=ListSets";
        log.info((Object)("Start harvesting using url: " + url));
        return this.downloadPage(url);
    }

    private String otherPages(String resumptionToken) throws CollectorServiceException {
        return this.downloadPage(this.baseUrl + "?verb=ListSets&resumptionToken=" + resumptionToken);
    }

    private String downloadPage(String url) throws CollectorServiceException {
        Document doc;
        String xml = this.httpConnector.getInputSource(url);
        try {
            doc = this.reader.read((Reader)new StringReader(xml));
        }
        catch (DocumentException e) {
            log.warn((Object)("Error parsing xml, I try to clean it: " + xml), (Throwable)e);
            String cleaned = XmlCleaner.cleanAllEntities(xml);
            try {
                doc = this.reader.read((Reader)new StringReader(cleaned));
            }
            catch (DocumentException e1) {
                throw new CollectorServiceException("Error parsing cleaned document:" + cleaned, (Throwable)e1);
            }
        }
        Node errorNode = doc.selectSingleNode("/*[local-name()='OAI-PMH']/*[local-name()='error']");
        if (errorNode != null) {
            String code = errorNode.valueOf("@code");
            if ("noRecordsMatch".equalsIgnoreCase(code.trim())) {
                log.warn((Object)("noRecordsMatch for oai call: " + url));
                return null;
            }
            throw new CollectorServiceException(code + " - " + errorNode.getText());
        }
        boolean sawAllSets = true;
        for (Object o : doc.selectNodes("//*[local-name()='ListSets']/*[local-name()='set']")) {
            String set = ((Element)o).valueOf("./*[local-name()='setSpec']");
            if (this.setsAlreadySeen.contains(set)) continue;
            sawAllSets = false;
            this.setsAlreadySeen.add(set);
            this.queue.add(((Node)o).asXML());
        }
        if (sawAllSets) {
            log.warn((Object)("URL " + this.baseUrl + " keeps returning the same OAI sets. Please contact the repo admin."));
            System.out.println("URL " + this.baseUrl + " keeps returning the same OAI sets. Please contact the repo admin.");
            return null;
        }
        return doc.valueOf("//*[local-name()='resumptionToken']");
    }
}

