/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DocumentNotFoundException;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreRetriever {
    private static final Log log = LogFactory.getLog(MDStoreRetriever.class);
    private MDStoreDao dao;
    private ResultSetFactory resultSetFactory;

    public ResultSet<String> deliver(String mdId, String from, String until, String recordFilter, boolean noCursorTimeout) throws MDStoreServiceException {
        MDStore mdStore = this.dao.readMDStore(mdId);
        return this.getResultSetFactory().createResultSet(mdStore.deliver(from, until, recordFilter, noCursorTimeout));
    }

    public Iterable<String> deliver(String format, String layout, String interpretation) throws MDStoreServiceException {
        try {
            return Iterables.concat((Iterable)Iterables.transform(this.dao.listMDStores(format, layout, interpretation), mdId -> {
                log.debug((Object)("bulk deliver of mdId: " + mdId));
                try {
                    return this.dao.readMDStore((String)mdId).iterate();
                }
                catch (MDStoreServiceException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (RuntimeException e) {
            throw new MDStoreServiceException((Throwable)e);
        }
    }

    public String deliverRecord(String mdId, String recordId) throws MDStoreServiceException, DocumentNotFoundException {
        return this.dao.getMDStore(mdId).getRecord(recordId);
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    @Required
    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

