/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.inspector;

import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ObjectStoreInspector
extends AbstractInspectorController {
    @Autowired
    private ObjectStoreDao objectStoreDao;

    @RequestMapping(value={"/inspector/objectstores.do"})
    public void objectStores(Model model) {
        List<String> objectStores = this.objectStoreDao.listObjectStores();
        List collect = objectStores.stream().map(id -> {
            try {
                ObjectStore objStore = this.objectStoreDao.getObjectStore((String)id);
                return new ObjectStoreDescription((String)id, objStore.getSize());
            }
            catch (ObjectStoreServiceException e) {
                return null;
            }
        }).collect(Collectors.toList());
        model.addAttribute("objectstores", collect);
    }

    @RequestMapping(value={"/inspector/objectstore.do"}, method={RequestMethod.GET})
    public void objectStore(Model model, @RequestParam(value="id") String id, @RequestParam(value="start", required=false) Integer startParam, @RequestParam(value="regex", required=false) String regex) throws ObjectStoreServiceException {
        ObjectStore objectStore = this.objectStoreDao.getObjectStore(id);
        int pageSize = 10;
        int start = 0;
        if (startParam != null) {
            start = startParam;
        }
        model.addAttribute("id", (Object)id);
        model.addAttribute("start", (Object)start);
        model.addAttribute("regex", (Object)regex);
        model.addAttribute("nextPage", (Object)(start + pageSize));
        model.addAttribute("prevPage", (Object)Math.max(0, start - pageSize));
        model.addAttribute("size", (Object)objectStore.getSize());
        model.addAttribute("page", objectStore.retrieveObjects(start, pageSize));
    }

    public ObjectStoreDao getObjectStoreDao() {
        return this.objectStoreDao;
    }

    public void setObjectStoreDao(ObjectStoreDao objectStoreDao) {
        this.objectStoreDao = objectStoreDao;
    }

    class ObjectStoreDescription {
        private String id;
        private int size;

        public ObjectStoreDescription(String id, int size) {
            this.id = id;
            this.size = size;
        }

        public String getInterpretation() throws ObjectStoreServiceException {
            ObjectStore objectStore = ObjectStoreInspector.this.objectStoreDao.getObjectStore(this.id);
            return objectStore.getInterpretation();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

