package eu.dnetlib.data.objectstore.plugins;

import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.data.AbstractDownloadPlugin;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.DownloadPlugin;

public class DummyPlugin extends AbstractDownloadPlugin implements DownloadPlugin {

	@Override
	public void setBasePath(String basePath) {

	}

	@Override
	public DownloadItem retrieveUrl(final DownloadItem item) {
		if (checkOpenAccess(item) == null) {
			return null;
		}
		if (filterByRegexp(item) == null) return null;
		String url = item.getUrl();

		if ((url == null) || (url.trim().length() == 0)) return null;
		@SuppressWarnings("unchecked")
		List<String> urls = new Gson().fromJson(url, ArrayList.class);
		if ((urls == null) || (urls.size() == 0)) {
			item.setOriginalUrl(null);
			item.setUrl(null);
			return item;
		}
		item.setOriginalUrl(urls.get(0));
		item.setUrl(urls.get(0));
		return item;
	}

	@Override
	public Iterable<DownloadItem> retrieveUrls(final Iterable<DownloadItem> items) {
		return DnetStreamSupport.generateStreamFromIterator(items.iterator()).map(input -> retrieveUrl(input))::iterator;
	}

	@Override
	public String getPluginName() {
		return "DummyPlugin";
	}

	@Override
	public String extractURL(String baseURL) {
		return null;
	}
}
