package eu.dnetlib.data.transformation.inspector;

import java.util.List;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.data.transformation.service.DataTransformerFactory;
import eu.dnetlib.data.transformation.service.SimpleDataTransformer;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DataTransformationController extends AbstractInspectorController {

	@Autowired
	private DataTransformerFactory dataTransformerFactory;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@RequestMapping(value = "/inspector/transform.do")
	public void transform(final Model model,
			@RequestParam(value = "rule", required = false) final String ruleId,
			@RequestParam(value = "record", required = false) final String record) throws Exception {

		model.addAttribute("rules", obtainRuleProfiles(ruleId));

		if (ruleId != null && record != null) {
			final SimpleDataTransformer transformer = dataTransformerFactory.createTransformer(ruleId);
			model.addAttribute("input", record);
			model.addAttribute("output", transformer.apply(record));
		}
	}

	private List<SelectOption> obtainRuleProfiles(final String currentId) throws ISLookUpException {
		String xquery = "for $x " +
				"in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') " +
				"return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//TITLE)";

		return Lists.transform(serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery), new Function<String, SelectOption>() {

			@Override
			public SelectOption apply(final String value) {
				final String[] arr = value.split("@@@");
				final String id = arr[0].trim();
				final String name = arr[1].trim();
				return new SelectOption(id, name, id.equals(currentId));
			}
		});
	}

	public static class SelectOption {

		private String id;
		private String name;
		private boolean selected;

		public SelectOption(final String id, final String name, final boolean selected) {
			this.id = id;
			this.name = name;
			this.selected = selected;
		}

		public String getId() {
			return id;
		}

		public String getName() {
			return name;
		}

		public boolean isSelected() {
			return selected;
		}
	}
}
