/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.service;

import eu.dnetlib.data.transformation.service.DataTransformerFactory;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.TransformationService;
import eu.dnetlib.rmi.data.TransformationServiceException;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TransformationServiceImpl
extends AbstractBaseService
implements TransformationService {
    private static final Log log = LogFactory.getLog(TransformationServiceImpl.class);
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private DataTransformerFactory dataTransformerFactory;

    public ResultSet<String> transform(String ruleid, ResultSet<String> rs) throws TransformationServiceException {
        try {
            return this.resultSetFactory.map(rs, String.class, (Function)this.dataTransformerFactory.createTransformer(ruleid));
        }
        catch (Throwable e) {
            log.error((Object)("Error generating mapped resultset - ruleId: " + ruleid), e);
            throw new TransformationServiceException("Error generating mapped resultset - ruleId: " + ruleid, e);
        }
    }
}

