package eu.dnetlib.data.collective.transformation.core.schema.visitor;

import com.sun.xml.xsom.*;
import com.sun.xml.xsom.visitor.XSTermVisitor;
import org.apache.commons.lang3.NotImplementedException;

/**
 * @author jochen
 */
public class XSTermVisitorImpl implements XSTermVisitor {

	private Visitor visitor;

	@Override
	public void elementDecl(XSElementDecl aElementDecl) {
		if (aElementDecl.isLocal()) {
			this.visitor.elementDecl(aElementDecl);
		} else {
			// ignore non local element declarations
		}
	}

	@Override
	public void modelGroup(XSModelGroup aModelGroup) {
		XSContentTypeVisitorImpl contentTypeVisitor = new XSContentTypeVisitorImpl();
		contentTypeVisitor.setVisitor(this.visitor);
		for (XSParticle p : aModelGroup.getChildren()) {
			contentTypeVisitor.particle(p);
		}
	}

	@Override
	public void modelGroupDecl(XSModelGroupDecl arg0) {
		throw new NotImplementedException("Method not implemented");
	}

	@Override
	public void wildcard(XSWildcard arg0) {
		throw new NotImplementedException("Method not implemented");
	}

	public Visitor getVisitor() {
		return visitor;
	}

	public void setVisitor(Visitor visitor) {
		this.visitor = visitor;
	}

}
