package eu.dnetlib.data.objectstore;

import javax.xml.ws.Endpoint;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

// TODO: Auto-generated Javadoc

/**
 * The Class ObjectStoreProfileCreator is responsible of creating profile of the ObjectStore
 */
public class ObjectStoreProfileCreator {

	private static final String ENDPOINT_TEMPLATE = "http://%s:%s/%s/services/objectStore";
	/**
	 * service locator.
	 */
	@Autowired
	private UniqueServiceLocator serviceLocator;
	/**
	 * objectstore ds template.
	 */
	private StringTemplate objectstoreDsTemplate;
	private String hostname;
	private String port;
	private String context;
	/**
	 * service endpoint.
	 */
	private Endpoint endpoint;

	/**
	 * endpoint builder.
	 */
	private EndpointReferenceBuilder<Endpoint> eprBuilder;

	/**
	 * Register profile.
	 *
	 * @param interpretation the interpretation
	 * @return the string
	 * @throws ISRegistryException the IS registry exception
	 */
	public String registerProfile(final String interpretation)
			throws ISRegistryException {
		// XXX: mini hack
		StringTemplate template = new StringTemplate(objectstoreDsTemplate.getTemplate());

		//template.setAttribute("serviceUri", eprBuilder.getAddress(endpoint));
		template.setAttribute("serviceUri", String.format(ENDPOINT_TEMPLATE, hostname, port, context));
		template.setAttribute("interpretation", interpretation);

		return serviceLocator.getService(ISRegistryService.class, true).registerProfile(template.toString());
	}

	/**
	 * Gets the endpoint.
	 *
	 * @return the endpoint
	 */
	public Endpoint getEndpoint() {
		return endpoint;
	}

	/**
	 * Sets the endpoint.
	 *
	 * @param endpoint the new endpoint
	 */

	public void setEndpoint(final Endpoint endpoint) {
		this.endpoint = endpoint;
	}

	/**
	 * Gets the epr builder.
	 *
	 * @return the epr builder
	 */
	public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
		return eprBuilder;
	}

	/**
	 * Sets the epr builder.
	 *
	 * @param eprBuilder the new epr builder
	 */
	@Required
	public void setEprBuilder(final EndpointReferenceBuilder<Endpoint> eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	/**
	 * Gets the objectstore ds template.
	 *
	 * @return the objectstore ds template
	 */
	public StringTemplate getObjectstoreDsTemplate() {
		return objectstoreDsTemplate;
	}

	/**
	 * Sets the objectstore ds template.
	 *
	 * @param objectstoreDsTemplate the new objectstore ds template
	 */
	@Required
	public void setObjectstoreDsTemplate(final StringTemplate objectstoreDsTemplate) {
		this.objectstoreDsTemplate = objectstoreDsTemplate;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public String getHostname() {
		return hostname;
	}

	@Required
	public void setHostname(final String hostname) {
		this.hostname = hostname;
	}

	public String getPort() {
		return port;
	}

	@Required
	public void setPort(final String port) {
		this.port = port;
	}

	public String getContext() {
		return context;
	}

	@Required
	public void setContext(final String context) {
		this.context = context;
	}

}
