/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.cleaner;

import com.google.common.collect.Lists;
import eu.dnetlib.rmi.data.CleanerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public abstract class XPATHCleaningRule {
    private String xpath;
    private boolean strict = false;
    private static final Log logCleaningRules = LogFactory.getLog((String)"VOCABULARY_RULES");

    public List<Map<String, String>> applyXpathRule(Document doc) throws CleanerException {
        ArrayList errors = Lists.newArrayList();
        String id = doc.valueOf("//*[local-name()='objIdentifier']");
        for (Object o : doc.selectNodes(this.xpath)) {
            Map<String, String> err;
            Node node = (Node)o;
            String oldValue = node.getText().trim();
            String newValue = this.calculateNewValue(oldValue);
            if (this.strict && (err = this.verifyValue(newValue)) != null) {
                errors.add(err);
                if (logCleaningRules.isInfoEnabled()) {
                    logCleaningRules.info((Object)("[" + newValue + "] is INVALID, RULE: " + this.toString() + ", RECORD: " + id + ", XPATH: " + this.getXpath()));
                }
            }
            if (logCleaningRules.isInfoEnabled() && !newValue.equals(oldValue)) {
                logCleaningRules.info((Object)("[" + oldValue + "] => [" + newValue + "], " + this.toString() + ", RECORD: " + id + ", XPATH: " + this.getXpath()));
            }
            node.setText(newValue);
        }
        return errors;
    }

    protected abstract Map<String, String> verifyValue(String var1) throws CleanerException;

    protected abstract String calculateNewValue(String var1) throws CleanerException;

    public String getXpath() {
        return this.xpath;
    }

    @Required
    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

