/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.core.schema;

import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.visitor.XSVisitor;
import eu.dnetlib.data.collective.transformation.core.schema.SchemaElement;
import eu.dnetlib.data.collective.transformation.core.schema.visitor.Visitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.SAXException;

public class SchemaInspector {
    private List<SchemaElement> elementList = new LinkedList<SchemaElement>();
    private boolean inspected = false;
    private String rootElement;

    public void inspect(File aSchema, String aRootElement) throws SAXException, IOException {
        XSOMParser parser = new XSOMParser();
        parser.parse(aSchema);
        this.doInspect(parser, aRootElement);
    }

    public void inspect(URL aSchema, String aRootElement) throws SAXException {
        XSOMParser parser = new XSOMParser();
        parser.parse(aSchema);
        this.doInspect(parser, aRootElement);
    }

    private void doInspect(XSOMParser parser, String aRootElement) throws SAXException {
        XSContentType contentType;
        XSParticle particle;
        this.rootElement = aRootElement;
        Visitor visitor = new Visitor();
        XSSchemaSet sset = parser.getResult();
        XSElementDecl elemDecl = sset.getElementDecl("", aRootElement);
        if (elemDecl == null) {
            throw new IllegalStateException("rootElement " + aRootElement + " not found in schema.");
        }
        if (elemDecl.getType().isComplexType() && (particle = (contentType = elemDecl.getType().asComplexType().getContentType()).asParticle()) != null) {
            XSTerm term = particle.getTerm();
            term.visit((XSVisitor)visitor);
        }
        this.elementList = visitor.getElements();
        this.inspected = true;
    }

    public boolean isInspected() {
        return this.inspected;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public List<SchemaElement> getChildElements() {
        return this.elementList;
    }
}

