/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.rmi.data.CollectorServiceRuntimeException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(SftpIterator.class);
    private static final int MAX_RETRIES = 2;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final long BACKOFF_MILLIS = 10000L;
    private String username;
    private String password;
    private String prvKeyFile;
    private String passPhrase;
    private String knownHostsFile;
    private String baseUrl;
    private String sftpURIScheme;
    private String sftpServerAddress;
    private String remoteSftpBasePath;
    private boolean isRecursive;
    private Set<String> extensionsSet;
    private boolean incremental;
    private Session sftpSession;
    private ChannelSftp sftpChannel;
    private Queue<String> queue;
    private LocalDateTime fromDate = null;
    private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private void init(String baseUrl, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.baseUrl = baseUrl;
        this.isRecursive = isRecursive;
        this.extensionsSet = extensionsSet;
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = LocalDateTime.from(LocalDate.parse(fromDate, this.simpleDateTimeFormatter).atStartOfDay());
            log.debug((Object)("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString()));
        }
        try {
            URI sftpServer = new URI(this.baseUrl);
            this.sftpURIScheme = sftpServer.getScheme();
            this.sftpServerAddress = sftpServer.getHost();
            this.remoteSftpBasePath = sftpServer.getPath();
        }
        catch (URISyntaxException e) {
            throw new CollectorServiceRuntimeException("Bad syntax in the URL " + baseUrl);
        }
    }

    public SftpIterator(String baseUrl, String username, String password, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.init(baseUrl, isRecursive, extensionsSet, fromDate);
        this.username = username;
        this.password = password;
        this.connectToSftpServerSimpleAuth();
        this.initializeQueue();
    }

    public SftpIterator(String baseUrl, String username, String prvKeyFilePath, String passPhrase, String knownHostsFile, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.init(baseUrl, isRecursive, extensionsSet, fromDate);
        this.username = username;
        this.passPhrase = passPhrase;
        this.prvKeyFile = prvKeyFilePath;
        this.knownHostsFile = knownHostsFile;
        this.connectToSftpServerPubKeyAuth();
        this.initializeQueue();
    }

    private void connectToSftpServerPubKeyAuth() {
        JSch jsch = new JSch();
        log.info((Object)("Connecting to " + this.sftpServerAddress + " with PubKey authentication"));
        log.info((Object)("Username " + this.username));
        log.info((Object)("Private key path: " + this.prvKeyFile));
        if (StringUtils.isNotBlank((CharSequence)this.passPhrase)) {
            log.info((Object)"with Pass phrase");
        }
        log.info((Object)("Known host file path: " + this.knownHostsFile));
        try {
            jsch.setKnownHosts(this.knownHostsFile);
            jsch.addIdentity(this.prvKeyFile, this.passPhrase);
            this.sftpSession = jsch.getSession(this.username, this.sftpServerAddress);
            this.sftpSession.connect();
            this.openChannelOnBasePath();
        }
        catch (JSchException e) {
            throw new CollectorServiceRuntimeException("Unable to create a session on remote SFTP server via Public key authentication.", (Throwable)e);
        }
    }

    private void connectToSftpServerSimpleAuth() {
        JSch jsch = new JSch();
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            this.sftpSession = jsch.getSession(this.username, this.sftpServerAddress);
            this.sftpSession.setPassword(this.password);
            this.sftpSession.connect();
            this.openChannelOnBasePath();
        }
        catch (JSchException e) {
            throw new CollectorServiceRuntimeException("Unable to create a session on remote SFTP server via simple authentication.", (Throwable)e);
        }
    }

    private void openChannelOnBasePath() {
        String fullPath = "";
        try {
            Channel channel = this.sftpSession.openChannel(this.sftpURIScheme);
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
            String pwd = this.sftpChannel.pwd();
            log.debug((Object)("PWD from server: " + pwd));
            fullPath = pwd + this.remoteSftpBasePath;
            this.sftpChannel.cd(fullPath);
            log.debug((Object)("PWD from server 2 after 'cd " + fullPath + "' : " + this.sftpChannel.pwd()));
            log.info((Object)("Connected to SFTP server " + this.sftpServerAddress));
        }
        catch (JSchException e) {
            throw new CollectorServiceRuntimeException("Unable to open/connect SFTP channel.", (Throwable)e);
        }
        catch (SftpException e) {
            throw new CollectorServiceRuntimeException("Unable to access the remote path " + fullPath + " on the SFTP server.", (Throwable)e);
        }
    }

    private void disconnectFromSftpServer() {
        this.sftpChannel.exit();
        this.sftpSession.disconnect();
    }

    private void initializeQueue() {
        this.queue = new LinkedList<String>();
        log.info((Object)String.format("SFTP collector plugin collecting from %s with recursion = %s, incremental = %s with fromDate=%s", this.remoteSftpBasePath, this.isRecursive, this.incremental, this.fromDate));
        this.listDirectoryRecursive(".", "");
    }

    private void listDirectoryRecursive(String parentDir, String currentDir) {
        String dirToList = parentDir;
        if (StringUtils.isNotBlank((CharSequence)currentDir)) {
            dirToList = dirToList + "/" + currentDir;
        }
        log.debug((Object)("PARENT DIR: " + parentDir));
        log.debug((Object)("DIR TO LIST: " + dirToList));
        try {
            Vector ls = this.sftpChannel.ls(dirToList);
            for (ChannelSftp.LsEntry entry : ls) {
                String currentFileName = entry.getFilename();
                if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                SftpATTRS attrs = entry.getAttrs();
                if (attrs.isDir()) {
                    if (!this.isRecursive) continue;
                    this.listDirectoryRecursive(dirToList, currentFileName);
                    continue;
                }
                for (String ext : this.extensionsSet) {
                    if (!currentFileName.endsWith(ext)) continue;
                    if (this.incremental) {
                        int mTime = attrs.getMTime();
                        Instant instant = Instant.ofEpochMilli((long)mTime * 1000L);
                        LocalDateTime dt = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
                        if (dt.isAfter(this.fromDate)) {
                            this.queue.add(dirToList + "/" + currentFileName);
                            log.debug((Object)(dirToList + "/" + currentFileName + " has changed and must be re-collected"));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(dirToList + "/" + currentFileName + " has not changed since last collection"));
                        continue;
                    }
                    this.queue.add(dirToList + "/" + currentFileName);
                }
            }
        }
        catch (SftpException e) {
            throw new CollectorServiceRuntimeException("Cannot list the sftp remote directory", (Throwable)e);
        }
    }

    @Override
    public boolean doHasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public String doNext() {
        if (this.queue.isEmpty()) {
            throw new CollectorServiceRuntimeException("Unexpected empty queue in next()");
        }
        String nextRemotePath = this.queue.remove();
        int nRepeat = 0;
        String fullPathFile = "";
        while (nRepeat < 2) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.sftpChannel.get(nextRemotePath, (OutputStream)baos);
                if (log.isDebugEnabled()) {
                    fullPathFile = this.sftpChannel.pwd() + "/" + nextRemotePath;
                    log.debug((Object)String.format("Collected file from SFTP: %s%s", this.sftpServerAddress, fullPathFile));
                }
                if (this.queue.isEmpty()) {
                    this.disconnectFromSftpServer();
                }
                return baos.toString();
            }
            catch (SftpException e) {
                log.warn((Object)String.format("An error occurred [%s] for %s%s, retrying.. [retried %s time(s)]", e.getMessage(), this.sftpServerAddress, fullPathFile, ++nRepeat));
                e.printStackTrace();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1);
                }
            }
        }
        throw new CollectorServiceRuntimeException(String.format("Impossible to retrieve FTP file %s after %s retries. Aborting FTP collection.", fullPathFile, nRepeat));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

