/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import eu.dnetlib.data.collector.plugins.sftp.AbstractSftpCollectorPlugin;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class SftpPubKeyCollectorPlugin
extends AbstractSftpCollectorPlugin {
    private static final Log log = LogFactory.getLog(SftpPubKeyCollectorPlugin.class);
    @Value(value="${collector.sftp.auth.prvKeyPath}")
    private String prvKeyFilePath;
    @Value(value="${collector.sftp.auth.passphrase}")
    private String passphrase;
    @Value(value="${collector.sftp.auth.knownHostsPath}")
    private String knownHostsFile;

    @Override
    protected Iterable<String> getIterable(InterfaceDescriptor interfaceDescriptor, String baseUrl, boolean isRecursive, Set<String> extensionSet, String fromDate) throws CollectorServiceException {
        String username = (String)interfaceDescriptor.getParams().get("username");
        if (StringUtils.isBlank((CharSequence)username)) {
            log.warn((Object)"Param 'username' is null or empty");
        }
        return () -> this.getSftpIteratorFactory().newIteratorPubKeyAuth(baseUrl, username, this.prvKeyFilePath, this.passphrase, this.knownHostsFile, isRecursive, extensionSet, fromDate);
    }
}

