/*
 * Decompiled with CFR 0.152.
 */
package prototype;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import prototype.utils.Capitalize;
import prototype.utils.DotAbbreviations;

public class PersonOrig {
    private static Set<String> particles = null;
    private List<String> name;
    private List<String> surname;
    private List<String> fullname;

    public PersonOrig(String s) {
        block9: {
            block7: {
                String[] arr;
                block8: {
                    this.name = Lists.newArrayList();
                    this.surname = Lists.newArrayList();
                    this.fullname = Lists.newArrayList();
                    s = Normalizer.normalize(s, Normalizer.Form.NFD);
                    s = s.replaceAll("\\(.+\\)", "");
                    s = s.replaceAll("\\[.+\\]", "");
                    s = s.replaceAll("\\{.+\\}", "");
                    s = s.replaceAll("\\s+-\\s+", "-");
                    s = s.replaceAll("[\\W&&[^,-]]", " ");
                    s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^,-]]", " ");
                    s = s.replaceAll("[\\p{Punct}&&[^-,]]", " ");
                    s = s.replaceAll("\\d", " ");
                    s = s.replaceAll("\\n", " ");
                    s = s.replaceAll("\\.", " ");
                    s = s.replaceAll("\\s+", " ");
                    if (!s.contains(",")) break block7;
                    arr = s.split(",");
                    if (arr.length != 1) break block8;
                    this.fullname = this.splitTerms(arr[0]);
                    break block9;
                }
                if (arr.length <= 1) break block9;
                this.surname = this.splitTerms(arr[0]);
                this.name = this.splitTerms(arr[1]);
                this.fullname.addAll(this.surname);
                this.fullname.addAll(this.name);
                break block9;
            }
            this.fullname = this.splitTerms(s);
            int lastInitialPosition = this.fullname.size();
            boolean hasSurnameInUpperCase = false;
            for (int i = 0; i < this.fullname.size(); ++i) {
                String term = this.fullname.get(i);
                if (term.length() == 1) {
                    lastInitialPosition = i;
                    continue;
                }
                if (!term.equals(term.toUpperCase())) continue;
                hasSurnameInUpperCase = true;
            }
            if (lastInitialPosition < this.fullname.size() - 1) {
                this.name = this.fullname.subList(0, lastInitialPosition + 1);
                this.surname = this.fullname.subList(lastInitialPosition + 1, this.fullname.size());
            } else if (hasSurnameInUpperCase) {
                for (String term : this.fullname) {
                    if (term.length() > 1 && term.equals(term.toUpperCase())) {
                        this.surname.add(term);
                        continue;
                    }
                    this.name.add(term);
                }
            }
        }
    }

    private List<String> splitTerms(String s) {
        ArrayList list = Lists.newArrayList();
        for (String part : Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)s)) {
            list.add(part);
        }
        return list;
    }

    public List<String> getName() {
        return this.name;
    }

    public List<String> getSurname() {
        return this.surname;
    }

    public List<String> getFullname() {
        return this.fullname;
    }

    public String hash() {
        return Hashing.murmur3_128().hashString((CharSequence)this.getNormalisedFullname(), StandardCharsets.UTF_8).toString();
    }

    public String getNormalisedFullname() {
        return this.isAccurate() ? Joiner.on((String)" ").join(this.getCapitalSurname()) + ", " + Joiner.on((String)" ").join(this.getNameWithAbbreviations()) : Joiner.on((String)" ").join(this.fullname);
    }

    public List<String> getCapitalSurname() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.surname, (Function)new Capitalize()));
    }

    public List<String> getNameWithAbbreviations() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.name, (Function)new DotAbbreviations()));
    }

    public boolean isAccurate() {
        return this.name != null && this.surname != null && !this.name.isEmpty() && !this.surname.isEmpty();
    }
}

