/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.cleaner.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.data.cleaner.CleaningRule;
import eu.dnetlib.data.cleaner.CleaningRuleFactory;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.rmi.data.CleanerException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class CleanerInspector
extends AbstractInspectorController {
    @Autowired
    private CleaningRuleFactory cleaningRuleFactory;

    @RequestMapping(value={"/inspector/cleaner.do"})
    public void cleaner(Model model, @RequestParam(value="rule", required=false) String ruleId, @RequestParam(value="dirtyText", required=false) String dirtyText) throws CleanerException {
        ArrayList rules = Lists.newArrayList(this.cleaningRuleFactory.getRuleIds());
        model.addAttribute("rules", this.selectOptions(rules, ruleId));
        if (ruleId != null && dirtyText != null) {
            CleaningRule rule = this.cleaningRuleFactory.obtainCleaningRule(ruleId);
            model.addAttribute("dirtyText", (Object)dirtyText);
            model.addAttribute("cleanedText", (Object)rule.apply(dirtyText));
        }
    }

    private List<SelectOption> selectOptions(List<String> input, String current) {
        return input.stream().map(it -> new SelectOption((String)it, it.equals(current))).collect(Collectors.toList());
    }

    public static class SelectOption {
        private String value;
        private boolean selected;

        public SelectOption(String value, boolean selected) {
            this.value = value;
            this.selected = selected;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

