/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.mongo;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.data.collector.ThreadSafeIterator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class MongoDumpIterator
extends ThreadSafeIterator {
    private final BufferedReader inputStream;
    private String currentLine = null;

    public MongoDumpIterator(FileReader inputStream) {
        this.inputStream = new BufferedReader(inputStream);
        this.currentLine = this.getNextLine();
    }

    @Override
    public boolean doHasNext() {
        return this.currentLine != null;
    }

    @Override
    public String doNext() {
        String returnedString = this.currentLine;
        this.currentLine = this.getNextLine();
        return returnedString;
    }

    private String getNextLine() {
        try {
            String input = this.inputStream.readLine();
            while (input != null) {
                JsonElement jElement = new JsonParser().parse(input);
                JsonObject jobject = jElement.getAsJsonObject();
                if (jobject.has("body")) {
                    return jobject.get("body").getAsString();
                }
                input = this.inputStream.readLine();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

