/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.rmi.data.DownloadPlugin;
import eu.dnetlib.rmi.data.DownloadPluginEnumerator;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class DownloadPluginEnumeratorImpl
implements DownloadPluginEnumerator {
    private ListableBeanFactory beanFactory;

    public Map<String, DownloadPlugin> getAll() {
        return this.beanFactory.getBeansOfType(DownloadPlugin.class);
    }

    public Map<String, DownloadPlugin> getByProtocols() {
        HashMap<String, DownloadPlugin> res = new HashMap<String, DownloadPlugin>();
        for (DownloadPlugin cp : this.getAll().values()) {
            res.put(cp.getPluginName().toLowerCase(), cp);
        }
        return res;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public DownloadPlugin get(String protocol) throws ObjectStoreServiceException {
        DownloadPlugin plugin = this.getByProtocols().get(protocol.toLowerCase());
        if (plugin == null) {
            throw new ObjectStoreServiceException("plugin not found for name: " + protocol);
        }
        return plugin;
    }
}

