/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.data.objectstore.ModularObjectStoreDeliver;
import eu.dnetlib.data.objectstore.ModularObjectStoreFeeder;
import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DownloadPluginEnumerator;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreService;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.util.List;
import org.springframework.beans.factory.annotation.Required;

public class ModularObjectStoreService
extends AbstractBaseService
implements ObjectStoreService {
    private ModularObjectStoreFeeder feeder;
    private ModularObjectStoreDeliver objectStoreDeliver;
    private NotificationHandler notificationHandler;
    private DownloadPluginEnumerator downloadPluginEnumerator;

    public ResultSet<ObjectStoreFile> deliverObjects(String obsId, Long from, Long until) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliver(obsId, from, until);
    }

    public ResultSet<ObjectStoreFile> deliverObjectsByIds(String obsId, ResultSet<String> eprId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliverIds(obsId, eprId);
    }

    public ObjectStoreFile deliverRecord(String obsId, String objectId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.deliverObject(obsId, objectId);
    }

    public List<String> getListOfObjectStores() {
        return this.objectStoreDeliver.getDao().listObjectStores();
    }

    public ModularObjectStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(ModularObjectStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public ModularObjectStoreDeliver getObjectStoreDeliver() {
        return this.objectStoreDeliver;
    }

    @Required
    public void setObjectStoreDeliver(ModularObjectStoreDeliver objectStoreDeliver) {
        this.objectStoreDeliver = objectStoreDeliver;
    }

    public void feedObject(String obsId, String objectMetadata) throws ObjectStoreServiceException {
        Gson g = new Gson();
        try {
            ObjectStoreFile file = (ObjectStoreFile)g.fromJson(objectMetadata, ObjectStoreFile.class);
            this.feeder.feedObject(obsId, file.getObjectID(), file.getURI(), file.getAccessProtocol(), file.getUsernameAuth(), file.getPasswordAuth(), file.getMimeType());
        }
        catch (Exception e) {
            throw new ObjectStoreServiceException(e.getMessage());
        }
    }

    public boolean existIDStartsWith(String obsId, String startId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.existIDStartsWith(obsId, startId);
    }

    public String feedObject(String obsId, ObjectStoreRecord record) throws ObjectStoreServiceException {
        try {
            return this.feeder.feedObjectRecord(obsId, record);
        }
        catch (Exception e) {
            throw new ObjectStoreServiceException(e.getMessage());
        }
    }

    public int getSize(String obsId) throws ObjectStoreServiceException {
        return this.objectStoreDeliver.getDao().getObjectStore(obsId).getSize();
    }

    public List<String> listDownloadPlugins() throws ObjectStoreServiceException {
        return Lists.newArrayList(this.getDownloadPluginEnumerator().getAll().keySet());
    }

    public DownloadPluginEnumerator getDownloadPluginEnumerator() {
        return this.downloadPluginEnumerator;
    }

    @Required
    public void setDownloadPluginEnumerator(DownloadPluginEnumerator downloadPluginEnumerator) {
        this.downloadPluginEnumerator = downloadPluginEnumerator;
    }
}

