/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.gridFS;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import eu.dnetlib.data.objectstore.gridFS.ObjectStoreFileUtility;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridFSObjectstoreResultSetListener
implements ResultSetListener<ObjectStoreFile> {
    private static final Log log = LogFactory.getLog(GridFSObjectstoreResultSetListener.class);
    private Long fromDate;
    private Long untilDate;
    private Iterable<String> records;
    private String objectStoreID;
    private GridFS collection;
    private String baseURI;
    private DBCursor currentCursor;

    public GridFSObjectstoreResultSetListener(Long fromDate, Long untilDate, String objectStoreID, GridFS collection, String baseURI, Iterable<String> records) {
        this.fromDate = fromDate;
        this.untilDate = untilDate;
        this.objectStoreID = objectStoreID;
        this.collection = collection;
        this.baseURI = baseURI;
        this.records = records;
        this.createCurrentCursor();
    }

    public boolean hasNext() {
        return this.currentCursor.hasNext();
    }

    public ObjectStoreFile next() throws ResultSetException {
        return ObjectStoreFileUtility.build((GridFSDBFile)this.currentCursor.next(), this.baseURI, this.objectStoreID);
    }

    public int getCount() {
        return this.currentCursor.itcount();
    }

    public int getTotal() {
        return this.currentCursor.count();
    }

    private void createCurrentCursor() {
        DBObject query;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Staring query ", new Object[0]));
        }
        if (this.records != null) {
            QueryBuilder qBuilder = QueryBuilder.start((String)"metadata.id").in(this.records);
            query = qBuilder.get();
        } else if (this.fromDate != null && this.untilDate != null) {
            query = new BasicDBObject();
            query.put("$gt", (Object)this.fromDate.doubleValue());
            query.put("$lt", (Object)this.untilDate.doubleValue());
            if (this.currentCursor != null) {
                this.currentCursor.close();
            }
        } else {
            throw new IllegalArgumentException("Missing parameters on Delivery must provide either from, to, or ObjectStoreIDs");
        }
        this.currentCursor = this.collection.getFileList((DBObject)new BasicDBObject("metadata.timestamp", (Object)query)).sort((DBObject)new BasicDBObject("_id", (Object)1));
    }

    public Long getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Long fromdate) {
        this.fromDate = fromdate;
    }

    public Long getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(Long untilDate) {
        this.untilDate = untilDate;
    }

    public Iterable<String> getRecords() {
        return this.records;
    }

    public void setRecords(Iterable<String> records) {
        this.records = records;
    }

    public GridFS getCollection() {
        return this.collection;
    }

    public void setCollection(GridFS collection) {
        this.collection = collection;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }
}

