package eu.dnetlib.data.cleaner;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CleanerException;
import eu.dnetlib.rmi.data.CleanerService;

public class CleanerServiceImpl extends AbstractBaseService implements CleanerService {

	private CleaningRuleFactory cleaningRuleFactory;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Override
	public ResultSet<String> clean(final ResultSet<String> rs, final String ruleId) throws CleanerException {
		if ((ruleId == null) || (ruleId.isEmpty())) { throw new CleanerException("Invalid ruleId: id is empty"); }
		if (rs == null) { throw new CleanerException("Passed rs is null"); }

		return this.resultSetFactory.map(rs, String.class, this.cleaningRuleFactory.obtainCleaningRule(ruleId));
	}

	public CleaningRuleFactory getCleaningRuleFactory() {
		return this.cleaningRuleFactory;
	}

	@Required
	public void setCleaningRuleFactory(final CleaningRuleFactory cleaningRuleFactory) {
		this.cleaningRuleFactory = cleaningRuleFactory;
	}

	public ResultSetFactory getResultSetFactory() {
		return this.resultSetFactory;
	}

	public void setResultSetFactory(final ResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

}
