package eu.dnetlib.data.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.Sets;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.*;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectorServiceImpl extends AbstractBaseService implements CollectorService {

	@Autowired
	private CollectorPluginEnumerator collectorPluginEnumerator;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Override
	public ResultSet<String> collect(final InterfaceDescriptor ifDescriptor) throws CollectorServiceException {
		return dateRangeCollect(ifDescriptor, null, null);
	}

	@Override
	public ResultSet<String> dateRangeCollect(
			final InterfaceDescriptor ifDescriptor, final String from, final String until)
			throws CollectorServiceException {
		final CollectorPlugin plugin = collectorPluginEnumerator.get(ifDescriptor.getProtocol());

		if (!verifyParams(ifDescriptor.getParams().keySet(), Sets.newHashSet(plugin.listNameParameters()))) {
			throw new CollectorServiceException(
					"Invalid parameters, valid: " + plugin.listNameParameters() + ", current: " + ifDescriptor.getParams().keySet());
		}

		final Iterable<String> iter = plugin.collect(ifDescriptor, from, until);

		return resultSetFactory.createResultSet(iter);
	}

	@Override
	public List<ProtocolDescriptor> listProtocols() {
		return collectorPluginEnumerator.getAll().stream().map(CollectorPlugin::getProtocolDescriptor).collect(Collectors.toList());

	}

	@Override
	public List<ProtocolParameterValue> listValidValuesForParam(final String protocol,
			final String baseUrl,
			final String param,
			final Map<String, String> otherParams) throws CollectorServiceException {
		final CollectorPlugin plugin = collectorPluginEnumerator.get(protocol);

		for (ProtocolParameter pp : plugin.getProtocolDescriptor().getParams()) {
			if (pp.getName().equals(param) && pp.isFunctionPopulated()) { return pp.getPopulateFunction().findValues(baseUrl, otherParams); }
		}
		return new ArrayList<>();
	}

	private boolean verifyParams(final Set<String> curr, final Set<String> valid) {
		return valid.containsAll(curr);
	}

}
