package eu.dnetlib.data.collector;

import java.util.Iterator;

/**
 * Created by Alessia Bardi on 10/04/17.
 *
 * Use this class instead of plain Iterator<String> when implementing new plugins in order to avoid problems when collecting while clicking on the workflow history.
 *
 * @author Alessia Bardi
 */
public abstract class ThreadSafeIterator implements Iterator<String> {

	@Override
	public synchronized boolean hasNext() {
		return doHasNext();
	}

	@Override
	public synchronized String next() {
		return doNext();
	}

	public abstract boolean doHasNext();
	public abstract String doNext();

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
}
