package eu.dnetlib.data.collector.plugins.filesfrommetadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import eu.dnetlib.rmi.data.functions.ParamValuesFunction;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

/**
 * Created by alessia on 17/12/15.
 */
public class PopulateFileDownloadBasePath implements ParamValuesFunction {

	private static final Log log = LogFactory.getLog(PopulateFileDownloadBasePath.class);
	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Value("${services.objectstore.basePathList.xquery}")
	private String xQueryForObjectStoreBasePath;

	@Override
	public List<ProtocolParameterValue> findValues(final String s, final Map<String, String> map) {
		try {
			return serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xQueryForObjectStoreBasePath)
					.stream()
					.map(it -> new ProtocolParameterValue(it, it))
					.collect(Collectors.toList());
		} catch (ISLookUpException e) {
			log.error("Cannot read Object store service properties", e);
		}
		return new ArrayList<>();
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	public void setServiceLocator(final UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public String getxQueryForObjectStoreBasePath() {
		return xQueryForObjectStoreBasePath;
	}

	public void setxQueryForObjectStoreBasePath(final String xQueryForObjectStoreBasePath) {
		this.xQueryForObjectStoreBasePath = xQueryForObjectStoreBasePath;
	}
}
