package eu.dnetlib.data.collector.plugins.mongo;

import java.io.*;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

import eu.dnetlib.rmi.data.CollectorServiceException;

// TODO: Auto-generated Javadoc

/**
 * The Class MongoDumpIterable.
 */
public class MongoDumpIterable implements Iterable<String> {

	/**
	 * The input stream.
	 */
	private final BufferedReader inputStream;

	/**
	 * Instantiates a new mongo dump iterable.
	 *
	 * @param inputFile the input file
	 * @throws CollectorServiceException the collection service exception
	 */
	public MongoDumpIterable(final File inputFile) throws CollectorServiceException {
		try {
			final GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(inputFile));

			Reader decoder = new InputStreamReader(gzipStream, "UTF-8");
			inputStream = new BufferedReader(decoder);
        } catch (Exception e) {
			throw new CollectorServiceException("Error unable to open inputStream", e);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Iterable#iterator()
	 */
	@Override
	public Iterator<String> iterator() {
		return new MongoDumpIterator(inputStream);
	}

}
