package eu.dnetlib.data.collector.plugins.sftp;

import java.util.Iterator;
import java.util.Set;

/**
 * Created by andrea on 11/01/16.
 */
public class SftpIteratorFactory {

	public Iterator<String> newIteratorSimplAuth(final String baseUrl,
			final String username,
			final String password,
			final boolean isRecursive,
			final Set<String> extensionsSet, final String fromDate) {
		return new SftpIterator(baseUrl, username, password, isRecursive, extensionsSet, fromDate);
	}

	public Iterator<String> newIteratorPubKeyAuth(final String baseUrl, String username,
			final String prvKeyFilePath, final String passPhrase, final String knownHostsFile,
			final boolean isRecursive,
			final Set<String> extensionsSet, final String fromDate) {
		return new SftpIterator(baseUrl, username, prvKeyFilePath, passPhrase,knownHostsFile, isRecursive, extensionsSet, fromDate);
	}
}
