package eu.dnetlib.data.mdstore.modular;

import javax.xml.ws.Endpoint;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import org.antlr.stringtemplate.StringTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreProfileCreator {

	private static final String ENDPOINT_TEMPLATE = "http://%s:%s/%s/services/mdStore";
	/**
	 * service locator.
	 */
	@Autowired
	private UniqueServiceLocator serviceLocator;
	/**
	 * mdstore ds template.
	 */
	private StringTemplate mdstoreDsTemplate;
	/**
	 * service endpoint.
	 */
	private Endpoint endpoint;
	private String hostname;
	private String port;
	private String context;
	/**
	 * endpoint builder.
	 */
	private EndpointReferenceBuilder<Endpoint> eprBuilder;

	public String registerProfile(String format, String interpretation, String layout) throws ISRegistryException {
		// XXX: mini hack
		StringTemplate template = new StringTemplate(mdstoreDsTemplate.getTemplate());
		//template.setAttribute("serviceUri", eprBuilder.getAddress(endpoint));
		template.setAttribute("serviceUri", String.format(ENDPOINT_TEMPLATE, hostname, port, context));
		template.setAttribute("format", format);
		template.setAttribute("interpretation", interpretation);
		template.setAttribute("layout", layout);

		return serviceLocator.getService(ISRegistryService.class).registerProfile(template.toString());
	}

	public StringTemplate getMdstoreDsTemplate() {
		return mdstoreDsTemplate;
	}

	@Required
	public void setMdstoreDsTemplate(StringTemplate mdstoreDsTemplate) {
		this.mdstoreDsTemplate = mdstoreDsTemplate;
	}

	public Endpoint getEndpoint() {
		return endpoint;
	}


	public void setEndpoint(Endpoint endpoint) {
		this.endpoint = endpoint;
	}

	public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
		return eprBuilder;
	}

	@Required
	public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
		this.eprBuilder = eprBuilder;
	}

	public UniqueServiceLocator getServiceLocator() {
		return serviceLocator;
	}

	@Required
	public void setServiceLocator(UniqueServiceLocator serviceLocator) {
		this.serviceLocator = serviceLocator;
	}

	public String getHostname() {
		return hostname;
	}

	@Required
	public void setHostname(final String hostname) {
		this.hostname = hostname;
	}

	public String getPort() {
		return port;
	}

	@Required
	public void setPort(final String port) {
		this.port = port;
	}

	public String getContext() {
		return context;
	}

	@Required
	public void setContext(final String context) {
		this.context = context;
	}
}
