package eu.dnetlib.data.objectstore;

import java.io.InputStream;

import eu.dnetlib.data.objectstore.connector.ObjectStoreDao;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

/**
 * The Class ModularObjectStoreDeliver is responsible of delivering data from the object Store.
 */
public class ModularObjectStoreDeliver {

	/**
	 * The dao.
	 */
	private ObjectStoreDao dao;

	/**
	 * The result set factory.
	 */

	@Autowired
	private ResultSetFactory resultSetFactory;

	/**
	 * Gets the dao.
	 *
	 * @return the dao
	 */
	public ObjectStoreDao getDao() {
		return dao;
	}

	/**
	 * Sets the dao.
	 *
	 * @param dao the new dao
	 */
	@Required
	public void setDao(final ObjectStoreDao dao) {
		this.dao = dao;
	}

	/**
	 * Deliver.
	 *
	 * @param objectStoreID the object store id
	 * @param from          the from
	 * @param until         the until
	 * @return the w3 c endpoint reference
	 * @throws ObjectStoreServiceException
	 */
	public ResultSet<ObjectStoreFile> deliver(final String objectStoreID, final Long from, final Long until) throws ObjectStoreServiceException {
		return resultSetFactory.createResultSet(dao.getObjectStore(objectStoreID).deliver(from, until));
	}

	/**
	 * Deliver ids.
	 *
	 * @param objectStoreID the object store id
	 * @param eprId         the epr id
	 * @return the w3 c endpoint reference
	 * @throws ObjectStoreServiceException
	 */
	public ResultSet<ObjectStoreFile> deliverIds(final String objectStoreID, final ResultSet<String> eprId) throws ObjectStoreServiceException {

		final ResultSetClient resultSetClient = resultSetFactory.getResultSetClient();
		Iterable<String> ids = resultSetClient.iter(eprId, String.class);
		return resultSetFactory.createResultSet(dao.getObjectStore(objectStoreID).deliverIds(ids));
	}

	/**
	 * Exist id starts with.
	 *
	 * @param obsId   the obs id
	 * @param startId the start id
	 * @return true, if successful
	 * @throws ObjectStoreServiceException
	 */
	public boolean existIDStartsWith(final String obsId, final String startId) throws ObjectStoreServiceException {
		return dao.getObjectStore(obsId).existIDStartsWith(startId);
	}

	/**
	 * Deliver object.
	 *
	 * @param objectStoreID the object store id
	 * @param objectId      the object id
	 * @return the object store file
	 * @throws ObjectStoreServiceException
	 */
	public ObjectStoreFile deliverObject(final String objectStoreID, final String objectId) throws ObjectStoreServiceException {
		return dao.getObjectStore(objectStoreID).deliverObject(objectId);
	}

	/**
	 * Deliver stream.
	 *
	 * @param objectStoreID the object store id
	 * @param objectId      the object id
	 * @return the input stream
	 * @throws ObjectStoreServiceException
	 */
	public InputStream deliverStream(final String objectStoreID, final String objectId) throws ObjectStoreServiceException {
		return dao.getObjectStore(objectStoreID).deliverStream(objectId);
	}

}
