package eu.dnetlib.data.objectstore;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

// TODO: Auto-generated Javadoc

/**
 * The Class ModularObjectStoreRESTService implement the controller REST of the object Store.
 */
@Controller
public class ModularObjectStoreRESTService {

	private static final Log log = LogFactory.getLog(ModularObjectStoreRESTService.class); // NOPMD by marko on 11/24/08 5:02 PM
	/**
	 * The object store deliver.
	 */
	@Autowired
	ModularObjectStoreDeliver objectStoreDeliver;

	/**
	 * Retrieve.
	 *
	 * @param res           the res
	 * @param objectStoreId the object store id
	 * @param objectId      the object id
	 * @throws IOException                 Signals that an I/O exception has occurred.
	 * @throws ObjectStoreServiceException
	 */
	@RequestMapping(value = "/**/objectStore/retrieve.do")
	public void retrieve(final HttpServletResponse res,
			@RequestParam(value = "objectStore", required = true) final String objectStoreId,
			@RequestParam(value = "objectId", required = true) final String objectId) throws IOException, ObjectStoreServiceException {

		final long start = System.currentTimeMillis();
		final ObjectStoreFile file = objectStoreDeliver.deliverObject(objectStoreId, objectId);

		log.debug(String.format("deliverObject completed in %s, objId: %s", HumanTime.exactly(System.currentTimeMillis() - start), objectId));

		if (file == null) throw new RuntimeException("The file with id " + objectId + " doesn't exist");

		// res.setContentType(file.getMimeType());

		InputStream is = objectStoreDeliver.deliverStream(objectStoreId, objectId);

		ServletOutputStream outputStream = res.getOutputStream();

		IOUtils.copy(is, outputStream);

		try {
			is.close();
			if (log.isDebugEnabled()) {
				log.debug(String.format("retrive.do completed in %s, objId: %s", HumanTime.exactly(System.currentTimeMillis() - start), objectId));
			}
		} catch (Throwable e) {
			log.error("unable to close input Stream", e);
		}

		/*
		 * while (true) { int readSize = is.read(buffer); if (readSize == -1) { break; } outputStream.write(buffer, 0, readSize); }
		 */
	}
}
