package eu.dnetlib.data.transformation.service;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.TransformationService;
import eu.dnetlib.rmi.data.TransformationServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TransformationServiceImpl extends AbstractBaseService implements TransformationService {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(TransformationServiceImpl.class);
	@Autowired
	private ResultSetFactory resultSetFactory;
	@Autowired
	private DataTransformerFactory dataTransformerFactory;

	@Override
	public ResultSet<String> transform(final String ruleid, final ResultSet<String> rs) throws TransformationServiceException {
		try {
			return resultSetFactory.map(rs, String.class, dataTransformerFactory.createTransformer(ruleid));
		} catch (Throwable e) {
			log.error("Error generating mapped resultset - ruleId: " + ruleid, e);
			throw new TransformationServiceException("Error generating mapped resultset - ruleId: " + ruleid, e);
		}
	}
}
