/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine.core;

import eu.dnetlib.data.collective.transformation.TransformationException;
import eu.dnetlib.data.collective.transformation.core.schema.SchemaInspector;
import eu.dnetlib.data.collective.transformation.engine.core.ITransformation;
import eu.dnetlib.data.collective.transformation.engine.core.StylesheetBuilder;
import eu.dnetlib.data.collective.transformation.rulelanguage.RuleLanguageParser;
import eu.dnetlib.data.collective.transformation.rulelanguage.Rules;
import eu.dnetlib.data.collective.transformation.utils.NamespaceContextImpl;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.instruct.TerminationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.Resource;

public class TransformationImpl
implements ITransformation {
    private static final String rootElement = "record";
    private final Log log = LogFactory.getLog(TransformationImpl.class);
    protected RuleLanguageParser ruleLanguageParser;
    private Document xslDoc;
    private SAXReader reader = new SAXReader();
    private Transformer transformer;
    private Transformer transformerFailed;
    private StylesheetBuilder stylesheetBuilder;
    private Map<String, String> staticResults = new LinkedHashMap<String, String>();
    private Map<String, String> jobConstantMap = new HashMap<String, String>();
    private Resource template;
    private Resource schema;
    private Source xsltSyntaxcheckFailed;
    private TransformerFactory saxonTransformerFactory;

    public TransformationImpl(TransformerFactory saxonTransformerFactory) {
        this.saxonTransformerFactory = saxonTransformerFactory;
    }

    public void init() {
        try {
            this.xslDoc = this.reader.read(this.template.getInputStream());
            Resource xslResource = this.template.createRelative("syntaxcheckfailed.xsl");
            String systemId = xslResource.getURL().toExternalForm();
            this.xsltSyntaxcheckFailed = new StreamSource(xslResource.getInputStream(), systemId);
        }
        catch (Throwable e) {
            this.log.error((Object)"cannot initialize this transformation.", e);
            throw new IllegalStateException(e);
        }
    }

    public void addJobConstant(String aKey, String aValue) {
        this.jobConstantMap.put(aKey, aValue);
    }

    public void configureTransformation() throws TransformerConfigurationException {
        this.saxonTransformerFactory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", Boolean.TRUE);
        Templates templates = null;
        templates = this.ruleLanguageParser.isXslStylesheet() ? this.saxonTransformerFactory.newTemplates(new StreamSource(new StringReader(this.ruleLanguageParser.getXslStylesheet()))) : this.saxonTransformerFactory.newTemplates(new StreamSource(this.createStylesheet()));
        this.transformer = templates.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("method", "xml");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        Templates templateFailed = this.saxonTransformerFactory.newTemplates(this.xsltSyntaxcheckFailed);
        this.transformerFailed = templateFailed.newTransformer();
    }

    @Override
    public String transformRecord(String record, int index) throws TerminationException, TransformationException {
        try {
            StreamSource s = new StreamSource(new StringReader(record));
            StringWriter writer = new StringWriter();
            StreamResult r = new StreamResult(writer);
            this.transformer.setParameter("index", index);
            this.transformer.transform(s, r);
            return writer.toString();
        }
        catch (TerminationException e) {
            this.log.debug((Object)e.getLocalizedMessage());
            throw e;
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
            throw new TransformationException(e);
        }
    }

    @Override
    public String transformRecord(String record, Map<String, String> parameters) throws TerminationException, TransformationException {
        try {
            StreamSource s = new StreamSource(new StringReader(record));
            StringWriter writer = new StringWriter();
            StreamResult r = new StreamResult(writer);
            for (String key : parameters.keySet()) {
                this.log.debug((Object)String.format("Add (%s, %s) ", key, parameters.get(key)));
                this.transformer.setParameter(key, parameters.get(key));
            }
            this.transformer.transform(s, r);
            return writer.toString();
        }
        catch (TerminationException e) {
            this.log.debug((Object)e.getLocalizedMessage());
            throw e;
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
            throw new TransformationException(e);
        }
    }

    @Override
    public String transformRecord(String record, String stylesheetName) throws TransformationException {
        if (!stylesheetName.equals("syntaxcheckfailed.xsl")) {
            throw new IllegalArgumentException("in TransformationImpl: stylesheetname " + stylesheetName + " is unsupported!");
        }
        try {
            StreamSource s = new StreamSource(new StringReader(record));
            StringWriter w = new StringWriter();
            StreamResult r = new StreamResult(w);
            this.transformerFailed.transform(s, r);
            return w.toString();
        }
        catch (TransformerException e) {
            this.log.error((Object)e);
            throw new TransformationException(e);
        }
    }

    public String dumpStylesheet() {
        return this.xslDoc.asXML();
    }

    public Resource getTemplate() {
        return this.template;
    }

    public void setTemplate(Resource template) {
        this.template = template;
    }

    @Override
    public RuleLanguageParser getRuleLanguageParser() {
        return this.ruleLanguageParser;
    }

    public void setRuleLanguageParser(RuleLanguageParser ruleLanguageParser) {
        this.ruleLanguageParser = ruleLanguageParser;
    }

    public StylesheetBuilder getStylesheetBuilder() {
        return this.stylesheetBuilder;
    }

    public void setStylesheetBuilder(StylesheetBuilder stylesheetBuilder) {
        this.stylesheetBuilder = stylesheetBuilder;
    }

    protected String getTransformationRules() {
        for (String string : this.jobConstantMap.keySet()) {
            Rules r = new Rules();
            r.setVariable(string);
            r.setConstant("'" + this.jobConstantMap.get(string) + "'");
            this.ruleLanguageParser.getVariableMappingRules().put("$job.datasinkid", r);
        }
        if (this.stylesheetBuilder == null) {
            this.stylesheetBuilder = new StylesheetBuilder(this.saxonTransformerFactory);
            this.stylesheetBuilder.setRuleLanguageParser(this.ruleLanguageParser);
            NamespaceContextImpl namespaceContext = new NamespaceContextImpl();
            for (String prefix : this.ruleLanguageParser.getNamespaceDeclarations().keySet()) {
                namespaceContext.addNamespace(prefix, this.ruleLanguageParser.getNamespaceDeclarations().get(prefix));
            }
            SchemaInspector schemaInspector = new SchemaInspector();
            try {
                schemaInspector.inspect(this.schema.getURL(), rootElement);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.stylesheetBuilder.setNamespaceContext(namespaceContext);
            this.stylesheetBuilder.setSchemaInspector(schemaInspector);
        }
        return this.stylesheetBuilder.createTemplate();
    }

    private Reader createStylesheet() {
        try {
            Document rulesDoc = DocumentHelper.parseText((String)this.getTransformationRules());
            for (String key : this.ruleLanguageParser.getNamespaceDeclarations().keySet()) {
                this.xslDoc.getRootElement().addNamespace(key, this.ruleLanguageParser.getNamespaceDeclarations().get(key));
            }
            List nodes = rulesDoc.getRootElement().selectNodes("//xsl:template");
            List varNodes = rulesDoc.getRootElement().selectNodes("/templateroot/xsl:param");
            for (Node node : varNodes) {
                this.xslDoc.getRootElement().add(((Element)node).detach());
            }
            for (Node node : nodes) {
                this.xslDoc.getRootElement().add(((Element)node).detach());
            }
        }
        catch (DocumentException e) {
            this.log.error((Object)("error in creating stylesheet: " + (Object)((Object)e)));
            throw new IllegalStateException(e);
        }
        String xsl = this.xslDoc.asXML();
        this.log.debug((Object)xsl);
        return new StringReader(xsl);
    }

    public Resource getSchema() {
        return this.schema;
    }

    public void setSchema(Resource schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, String> getStaticTransformationResults() {
        return this.staticResults;
    }

    @Override
    public Map<String, String> getJobProperties() {
        return this.jobConstantMap;
    }

    @Override
    public Properties getLogInformation() {
        return null;
    }
}

