/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.rulelanguage;

import eu.dnetlib.data.collective.transformation.rulelanguage.IRule;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTMyScript;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ASTStart;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.FtScript;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.ParseException;
import eu.dnetlib.data.collective.transformation.rulelanguage.parser.SimpleNode;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import eu.dnetlib.data.collective.transformation.rulelanguage.visitor.AbstractVisitor;
import eu.dnetlib.data.collective.transformation.rulelanguage.visitor.RuleLanguageVisitor;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleLanguageParser {
    private static final Log log = LogFactory.getLog(RuleLanguageParser.class);
    protected static FtScript scriptParser = null;
    private RuleLanguageVisitor visitor = new RuleLanguageVisitor();
    private String xslStylesheet = null;

    public void parse(InputStream inStream) {
        if (scriptParser == null) {
            scriptParser = new FtScript(inStream);
        }
        scriptParser.ReInit(inStream);
        this.parsingAndTraversing();
    }

    public void parse(Reader inRead) {
        if (scriptParser == null) {
            scriptParser = new FtScript(inRead);
        }
        scriptParser.ReInit(inRead);
        this.parsingAndTraversing();
    }

    private void parsingAndTraversing() {
        try {
            ASTStart start = scriptParser.Start();
            this.traverseTree(start, this.visitor);
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new IllegalStateException(e);
        }
    }

    public String getScriptName() {
        return this.visitor.getScriptName();
    }

    public ASTMyScript.SCRIPTTYPE getScriptType() {
        return this.visitor.getScriptType();
    }

    public Map<String, Set<IRule>> getElementMappingRules() {
        return this.visitor.getElementMappingRules();
    }

    public Map<String, IRule> getVariableMappingRules() {
        return this.visitor.getVariableMappingRules();
    }

    public Map<String, IRule> getTemplateMappingRules() {
        return this.visitor.getTemplateMappingRules();
    }

    public List<String> getImportedScripts() {
        return this.visitor.getImportedScripts();
    }

    public Map<String, String> getNamespaceDeclarations() {
        return this.visitor.getNamespaceDeclarations();
    }

    public List<FunctionCall> getFunctionCalls() {
        return this.visitor.getFunctionCalls();
    }

    public List<Map<String, String>> getPreprocessings() {
        return this.visitor.getPreprocessings();
    }

    public String getXslStylesheet() {
        return this.xslStylesheet;
    }

    public boolean isXslStylesheet() {
        return this.xslStylesheet != null;
    }

    public void setXslStylesheet(String xslStylesheet) {
        this.xslStylesheet = xslStylesheet;
    }

    public void addRulesFromParser(RuleLanguageParser aParser) {
        this.visitor.getFunctionCalls().addAll(aParser.getFunctionCalls());
        this.visitor.getElementMappingRules().putAll(aParser.getVisitor().getElementMappingRules());
        this.visitor.getVariableMappingRules().putAll(aParser.getVisitor().getVariableMappingRules());
        this.visitor.getTemplateMappingRules().putAll(aParser.getVisitor().getTemplateMappingRules());
        this.visitor.getNamespaceDeclarations().putAll(aParser.getNamespaceDeclarations());
    }

    protected RuleLanguageVisitor getVisitor() {
        return this.visitor;
    }

    private void traverseTree(SimpleNode node, AbstractVisitor visitor) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleNode sn = (SimpleNode)node.jjtGetChild(i);
            sn.jjtAccept(visitor, null);
            this.traverseTree(sn, visitor);
        }
    }
}

