/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.utils;

import eu.dnetlib.common.profile.ProfileNotFoundException;
import eu.dnetlib.data.collective.transformation.rulelanguage.RuleLanguageParser;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.StringReader;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TransformationRulesImportTool {
    @Autowired
    private UniqueServiceLocator lookupServiceLocator;

    protected List<String> getScript(String aProfileId) throws ProfileNotFoundException {
        String xquery = "string(collection('/db/DRIVER/TransformationRuleDSResources')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + aProfileId + "']//CODE), for $id in (collection('/db/DRIVER/TransformationRuleDSResources')//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value ='" + aProfileId + "']//IMPORTED/SCRIPT_REFERENCE/@id) return string($id)";
        try {
            List queryResult = ((ISLookUpService)this.lookupServiceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery);
            if (!queryResult.isEmpty()) {
                return queryResult;
            }
            throw new ProfileNotFoundException("no script found in profile for profileId: " + aProfileId);
        }
        catch (ISLookUpException e) {
            throw new ProfileNotFoundException(e);
        }
    }

    protected void importRules(RuleLanguageParser aParser, String aProfileId) throws ProfileNotFoundException {
        List<String> profileQueryResult = this.getScript(aProfileId);
        String script = profileQueryResult.get(0);
        if (script.trim().startsWith("<xsl:stylesheet")) {
            aParser.setXslStylesheet(script.trim());
        } else {
            StringReader reader = new StringReader(script);
            aParser.parse(reader);
            if (aParser.getImportedScripts().size() != profileQueryResult.size() - 1) {
                throw new IllegalStateException("invalid number of scripts to import: " + aParser.getImportedScripts().size() + " != " + profileQueryResult.size());
            }
            if (!aParser.getImportedScripts().isEmpty()) {
                for (String importScriptProfileId : profileQueryResult.subList(1, profileQueryResult.size())) {
                    RuleLanguageParser childParser = new RuleLanguageParser();
                    this.importRules(childParser, importScriptProfileId);
                    aParser.addRulesFromParser(childParser);
                }
            }
        }
    }

    public RuleLanguageParser getRuleLanguageParser(String aProfileId) throws ProfileNotFoundException {
        RuleLanguageParser parser = new RuleLanguageParser();
        this.importRules(parser, aProfileId);
        return parser;
    }
}

