/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.archive.targz;

import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.archive.targz.TarGzIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;

public class TarGzIterable
implements Iterable<String> {
    private File tarGzFile;
    private Set<String> extensionSet;

    public TarGzIterable(InterfaceDescriptor interfaceDescriptor, Set<String> extensionSet) throws CollectorServiceException {
        try {
            String tarGzPath = interfaceDescriptor.getBaseUrl();
            URL tarGzUrl = new URL(tarGzPath);
            this.tarGzFile = new File(tarGzUrl.getPath());
            if (!this.tarGzFile.exists()) {
                throw new CollectorServiceException(String.format("The base URL %s, does not exist", this.tarGzFile.getPath()));
            }
            this.extensionSet = extensionSet;
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("TarGz collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        TarGzIterator tgzIterator = new TarGzIterator(this.tarGzFile.getAbsolutePath(), this.extensionSet);
        return Iterators.transform((Iterator)tgzIterator, inputRecord -> XmlCleaner.cleanAllEntities(inputRecord.startsWith("\ufeff") ? inputRecord.substring(1) : inputRecord));
    }
}

