/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.archive.zip;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.archive.zip.ZipIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public class ZipIterable
implements Iterable<String> {
    private File zipFile;

    public ZipIterable(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        try {
            String zipPath = interfaceDescriptor.getBaseUrl();
            URL zipUrl = new URL(zipPath);
            this.zipFile = new File(zipUrl.getPath());
            if (!this.zipFile.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", this.zipFile.getPath()));
            }
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("Zip collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        ZipIterator zipIterator = new ZipIterator(this.zipFile.getAbsolutePath());
        return Iterators.transform((Iterator)zipIterator, (Function)new Function<String, String>(){

            public String apply(String inputRecord) {
                return XmlCleaner.cleanAllEntities(inputRecord.startsWith("\ufeff") ? inputRecord.substring(1) : inputRecord);
            }
        });
    }
}

