/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.BsonSerializationException;
import org.bson.conversions.Bson;

public class MongoBulkWritesManager {
    private static final Log log = LogFactory.getLog(MongoBulkWritesManager.class);
    private final boolean discardRecords;
    private RecordParser recordParser;
    private MongoCollection<DBObject> validCollection;
    private List<WriteModel<DBObject>> validBulkOperationList;
    private BulkWriteOptions writeOptions;
    private MongoCollection<DBObject> discardedCollection;
    private List<WriteModel<DBObject>> discardedBulkOperationList;
    private int discardedOpCounter;
    private int bulkSize;

    public MongoBulkWritesManager(MongoCollection<DBObject> collection, MongoCollection<DBObject> discardedCollection, int bulkSize, RecordParser parser, boolean discardRecords) {
        this.validCollection = collection.withWriteConcern(WriteConcern.JOURNALED);
        this.validBulkOperationList = Lists.newArrayList();
        this.discardedCollection = discardedCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.discardedBulkOperationList = Lists.newArrayList();
        this.discardedOpCounter = 0;
        this.bulkSize = bulkSize;
        this.recordParser = parser;
        this.discardRecords = discardRecords;
        this.writeOptions = new BulkWriteOptions().ordered(false);
    }

    public void insert(String record) {
        block10: {
            try {
                Map<String, String> recordProperties = this.recordParser.parseRecord(record);
                if (recordProperties.containsKey("id")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Parsed record id " + recordProperties.get("id")));
                    }
                    DBObject obj = this.buildDBObject(record, recordProperties);
                    this.validBulkOperationList.add((WriteModel<DBObject>)new ReplaceOneModel((Bson)new BasicDBObject("id", obj.get("id")), (Object)obj, new UpdateOptions().upsert(true)));
                    if (this.validBulkOperationList.size() % this.bulkSize == 0 && !this.validBulkOperationList.isEmpty()) {
                        log.debug((Object)("Bulk writing #records: " + this.validBulkOperationList.size()));
                        BulkWriteResult res = this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Inserted: " + res.getInsertedCount()));
                            if (res.isModifiedCountAvailable()) {
                                log.debug((Object)("Modified: " + res.getModifiedCount()));
                            }
                        }
                        this.validBulkOperationList = Lists.newArrayList();
                    }
                } else if (this.discardRecords) {
                    log.debug((Object)"parsed record seems invalid");
                    this.discardRecord(record);
                }
            }
            catch (BsonSerializationException e) {
                log.error((Object)("Probably too big XML record: " + e.getMessage()), (Throwable)e);
                log.error((Object)("Dropping operation list -- #ops " + this.validBulkOperationList.size()));
                this.validBulkOperationList = Lists.newArrayList();
            }
            catch (XMLStreamException e) {
                if (!this.discardRecords) break block10;
                log.error((Object)("unhandled exception: " + e.getMessage()), (Throwable)e);
                this.discardRecord(record);
            }
        }
    }

    private void discardRecord(String record) {
        this.discardedCollection.insertOne((Object)new BasicDBObject("body", (Object)record));
    }

    public void flushBulks() {
        if (!this.validBulkOperationList.isEmpty()) {
            this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
        }
    }

    private DBObject buildDBObject(String record, Map<String, String> recordProperties) {
        BasicDBObject obj = new BasicDBObject();
        obj.put("id", (Object)recordProperties.get("id"));
        obj.put("originalId", (Object)recordProperties.get("originalId"));
        obj.put("body", (Object)record);
        obj.put("timestamp", (Object)System.currentTimeMillis());
        return obj;
    }

    private MongoCollection<DBObject> getCollectionWithWriteConcern(MongoCollection<DBObject> collection, WriteConcern writeConcern) {
        return collection.withWriteConcern(writeConcern);
    }
}

